# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.common.types.misc import NotExists
from sandbox.projects.modadvert import resource_types
from sandbox.projects.modadvert.RunLyncherSDK2 import ModadvertRunLyncherSDK2


DUMMY_PARAMETER = sdk2.parameters.Integer(
    'Dummy parameter',
    ui=False,
    required=False,
    dummy=True,
    default_value=0
)


class ModadvertRunOfflineLyncherSDK2(ModadvertRunLyncherSDK2):

    class Parameters(ModadvertRunLyncherSDK2.Parameters):

        # Hiding unnecessary parameters
        src_tables_dir = DUMMY_PARAMETER()
        requests_table = DUMMY_PARAMETER()
        state_path = DUMMY_PARAMETER()
        max_tables_count = DUMMY_PARAMETER()

        # Overriding binary resource property
        with ModadvertRunLyncherSDK2.Parameters.binaries_group() as binaries_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with all offline lyncher binaries',
                resource_type=resource_types.MODADVERT_OFFLINE_LYNCHER_BINARIES
            )

        # New properties
        with sdk2.parameters.Group('Input requests params') as input_params_group:
            src_dir = sdk2.parameters.String(
                'Source dir with requests',
                default_value='//home/modadvert/lyncher/input',
                required=True
            )
            lookup_offset_days = sdk2.parameters.Integer(
                'Max lifetime of row',
                required=True,
                default_value=30
            )

    def create_command(self):
        lyncher_cmd = [
            './offline_lyncher',

            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--conf', './default_config.yaml',
            '--src-dir', self.Parameters.src_dir,
            '--verdicts-log-table', self.Parameters.verdicts_table,
            '--lookup-offset-days', str(self.Parameters.lookup_offset_days),

            '--logging-level', str(self.Parameters.logging_level),
            '--iterations', '1',
        ]

        if self.Parameters.debug and self.Parameters.debug is not NotExists:
            lyncher_cmd.append('--testing')

        if self.Parameters.use_synchrophazotron and self.Parameters.use_synchrophazotron is not NotExists:
            lyncher_cmd.extend(['--synchrophazotron-command', str(self.path('synchrophazotron'))])

        return lyncher_cmd
