# -*- coding=utf-8 -*-
from sandbox import sdk2

from sandbox.common.types.misc import NotExists
from sandbox.projects.modadvert import resource_types
from sandbox.projects.modadvert.RunLyncherSDK2 import ModadvertRunLyncherSDK2


class ModadvertRunQlyncher(ModadvertRunLyncherSDK2):

    class Parameters(ModadvertRunLyncherSDK2.Parameters):

        with ModadvertRunLyncherSDK2.Parameters.binaries_group() as binaries_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with all offline QLyncher binaries',
                resource_type=resource_types.MODADVERT_QLYNCHER_BINARIES
            )
        with ModadvertRunLyncherSDK2.Parameters.launch_group() as launch_group:
            iterations = sdk2.parameters.Integer('Iterations per launch', default=1)
            max_rows_count = sdk2.parameters.Integer(
                'Maximum rows count to process per launch',
                required=False, default=10 ** 7
            )
            max_tables_age = sdk2.parameters.Integer(
                'Max tables age to process in hours',
                required=False, default=8
            )
            max_tables_count = sdk2.parameters.Integer(
                'Max tables count',
                required=False, default=100
            )

    def create_command(self):
        lyncher_cmd = [
            './qlyncher',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--src-table-dir', self.Parameters.src_tables_dir,
            '--verdicts-log-table', self.Parameters.verdicts_table,
            '--state-path', self.Parameters.state_path,
            '--max-tables-age', self.Parameters.max_tables_age,
            '--primary-read-cluster', self.Parameters.primary_read_cluster,
            '--secondary-read-cluster', self.Parameters.secondary_read_cluster,
            '--conf', './default_config.yaml',
            '--iterations', self.Parameters.iterations,
            '--logging-level', self.Parameters.logging_level,
            '--max-table-row-count', self.Parameters.max_rows_count
        ]

        if self.Parameters.debug and self.Parameters.debug is not NotExists:
            lyncher_cmd.append('--testing')

        if self.Parameters.max_tables_count and self.Parameters.max_tables_count is not NotExists:
            lyncher_cmd.extend(['--max-tables-count', str(self.Parameters.max_tables_count)])

        if self.Parameters.use_synchrophazotron and self.Parameters.use_synchrophazotron is not NotExists:
            lyncher_cmd.extend(['--synchrophazotron-command', str(self.path('synchrophazotron'))])

        return lyncher_cmd
