# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertRunSmBinary(modadvert.ModadvertBaseRunSupermoderation):
    """
    MODADVERT-898: upload to SM from prod-*-queue
    """

    class Parameters(modadvert.ModadvertBaseRunSupermoderation.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with task binary',
                resource_type=resource_types.YA_PACKAGE,
                required=True
            )

        with modadvert.ModadvertBaseRunSupermoderation.Parameters.launch_group() as launch_group:
            base_cmd = sdk2.parameters.List('Base cmd', default=['./binary'], required=True)

    def get_base_cmd(self):
        return self.Parameters.base_cmd
