# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert import resource_types
from sandbox.projects.modadvert.common import modadvert

class RunningMode(sdk2.parameters.String):
    choices = (
        ('backup', 'backup'),
        ('transfer', 'transfer'),
        ('backup, transfer', 'backup, transfer'),
    )

class ModadvertRunTransferManager(modadvert.ModadvertBaseYtTask):
    """
    Transfer tables from one cluster to another
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Transfer manager binaries resource',
                resource_type=resource_types.MODADVERT_TRANSFER_BINARY,
                required=True
            )

        with sdk2.parameters.Group('Config') as config:
            config_resource = sdk2.parameters.Resource(
                'Resource with Transfer config',
                resource_type=resource_types.MODADVERT_TRANSFER_CONFIG,
                required=True
            )

        with sdk2.parameters.Group('Additional') as additional:
            row_batch_size = sdk2.parameters.Integer('dynamic_table_row_batch_size', default_value=100000)
            mode = RunningMode('running_mode', default_value='backup, transfer')

        with modadvert.ModadvertBaseYtTask.Parameters.clusters_group() as clusters_group:
            yt_worker_proxy_url = modadvert.YtCluster('YT worker cluster', default='arnold')

    def on_before_execute(self):
        super(ModadvertRunTransferManager, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)
        self.untar_resource(self.Parameters.config_resource)

    def on_execute_inner(self):
        mode = self.Parameters.mode.split(', ')
        binary_cmd = [
            './transfer_manager',
            '--row-batch-size', self.Parameters.row_batch_size,
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--yt-worker-proxy-url', self.Parameters.yt_worker_proxy_url,
            '--conf', './config.yaml',
            '--mode'
        ] + mode

        self.run_command(binary_cmd)
