# -*- coding: utf-8 -*-
from sandbox import sdk2


from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertSaveSMResults(modadvert.ModadvertBaseYtTask):

    name = 'MODADVERT_SAVE_SM_RESULTS'

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with task binary',
                resource_type=resource_types.MODADVERT_SAVE_SM_RESULTS_BINARY,
                required=True
            )
        src_dir = sdk2.parameters.String('Source yt directory', required=True)
        dst_dir = sdk2.parameters.String('Destination yt directory', required=True)
        log_table = sdk2.parameters.String('Log table yt path', required=True)

    def create_command(self):
        cmd = [
            './save_tables',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--src-dir-path', self.Parameters.src_dir,
            '--dst-dir-path', self.Parameters.dst_dir,
            '--log-table-path', self.Parameters.log_table
        ]
        return cmd

    def on_execute_inner(self):
        self.untar_resource(self.Parameters.binaries_resource)
        self.run_command(self.create_command(), log_prefix="main", env=self.create_env())
