# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertSendCircuitLogMetrics(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-1526: Lyncher verdicts rules graphics.
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with send_circuit_log_metrics binary',
                resource_type=[resource_types.MODADVERT_SEND_CIRCUIT_LOG_METRICS_BINARY],
                required=True
            )

        with sdk2.parameters.Group('Options') as options_group:
            state_path = sdk2.parameters.String(
                'State path',
                default='//home/modadvert/states/lyncher_stats',
                required=True
            )
            stat_table = sdk2.parameters.String(
                'Stat table',
                default='//home/modadvert/states/LyncherStatsHistory',
                required=True
            )
            verdicts_log_tables = sdk2.parameters.List(
                'Verdicts tables',
                default=['//home/modadvert/lyncher/Results'],
                required=True
            )

        with sdk2.parameters.Group('Time options') as time_options_group:
            wait_time = sdk2.parameters.Integer(
                'Wait time (seconds)',
                default=60 * 60 * 24 * 7,
                required=True
            )
            vanish_time = sdk2.parameters.Integer(
                'Vanish time (seconds)',
                default=60 * 60 * 24 * 1,
                required=True
            )

    def on_before_execute(self):
        super(ModadvertSendCircuitLogMetrics, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './send_circuit_log_metrics',
            '--yt-worker-proxy-url', self.Parameters.yt_proxy_url,
            '--stat-table', self.Parameters.stat_table,
            '--state-path', self.Parameters.state_path,
            '--wait-time', str(self.Parameters.wait_time),
            '--vanish-time', str(self.Parameters.vanish_time),
        ]
        binary_cmd.extend(['--verdicts-log-table'] + self.Parameters.verdicts_log_tables)
        self.run_command(binary_cmd)
