from sandbox import sdk2

from sandbox.projects.modadvert import resource_types
from sandbox.projects.modadvert.common import modadvert


class ModadvertSupermoderationB2B(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-245: Task for supermoderation b2b
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Common'):
            b2b_binary_package = sdk2.parameters.Resource(
                'Resource with b2b binary',
                resource_type=resource_types.MODADVERT_SUPERMODERATION_B2B_BINARY,
            )
            yt_proxy_url = sdk2.parameters.String(
                'Yt Cluster Url',
                default='arnold'
            )
            input_table = sdk2.parameters.String(
                'Input Table Path',
                required=True,
            )

        with sdk2.parameters.Group('Resourses Base'):
            base_api_package = sdk2.parameters.Resource(
                'Resourse with api binary',
            )
            base_broker_package = sdk2.parameters.Resource(
                'Resource with broker binary',
                resource_type=resource_types.MODADVERT_SM_BROKER_BINARY,
            )
            base_conf_package = sdk2.parameters.Resource(
                'Resource with conf',
                resource_type=[
                    resource_types.MODADVERT_SM_CONFIG,
                    resource_types.MODADVERT_SM_CONFIG_DEV,
                    resource_types.MODADVERT_SM_CONFIG_TESTING,
                    resource_types.MODADVERT_SM_CONFIG_PROD,
                ]
            )
            base_service_confs_package = sdk2.parameters.Resource(
                'Resource with service conf',
                resource_type=[
                    resource_types.MODADVERT_SM_SERVICE_CONFIG,
                    resource_types.MODADVERT_SM_SERVICE_CONFIG_DEV,
                    resource_types.MODADVERT_SM_SERVICE_CONFIG_TESTING,
                    resource_types.MODADVERT_SM_SERVICE_CONFIG_PROD,
                ]
            )

        with sdk2.parameters.Group('Resourses Feature'):
            feature_api_package = sdk2.parameters.Resource(
                'Resourse with api binary',
            )
            feature_broker_package = sdk2.parameters.Resource(
                'Resource with broker binary',
                resource_type=resource_types.MODADVERT_SM_BROKER_BINARY,
            )
            feature_conf_package = sdk2.parameters.Resource(
                'Resource with conf',
                resource_type=[
                    resource_types.MODADVERT_SM_CONFIG,
                    resource_types.MODADVERT_SM_CONFIG_DEV,
                    resource_types.MODADVERT_SM_CONFIG_TESTING,
                    resource_types.MODADVERT_SM_CONFIG_PROD,
                ]
            )
            feature_service_confs_package = sdk2.parameters.Resource(
                'Resource with service conf',
                resource_type=[
                    resource_types.MODADVERT_SM_SERVICE_CONFIG,
                    resource_types.MODADVERT_SM_SERVICE_CONFIG_DEV,
                    resource_types.MODADVERT_SM_SERVICE_CONFIG_TESTING,
                    resource_types.MODADVERT_SM_SERVICE_CONFIG_PROD,
                ]
            )

    def on_execute(self):

        self.untar_resource(self.Parameters.b2b_binary_package)

        # unpack base resourses
        self.untar_resource(self.Parameters.base_api_package, dst_dir='base')
        self.untar_resource(self.Parameters.base_broker_package, dst_dir='base')
        self.untar_resource(self.Parameters.base_conf_package, dst_dir='base')
        self.untar_resource(self.Parameters.base_service_confs_package, dst_dir='base/service_confs')

        # unpack feature resourses
        self.untar_resource(self.Parameters.base_api_package, dst_dir='feature')
        self.untar_resource(self.Parameters.base_broker_package, dst_dir='feature')
        self.untar_resource(self.Parameters.base_conf_package, dst_dir='feature')
        self.untar_resource(self.Parameters.base_service_confs_package, dst_dir='feature/service_confs')

        b2b_command = [
            './supermoderation_b2b',

            '--base-api-binary', './base/supermoderation_api',
            '--base-broker-binary', './base/supermoderation_broker',
            '--base-conf', './base/config.yaml',
            '--base-service-conf-dir', './base/service_confs',

            '--feature-api-binary', './feature/supermoderation_api',
            '--feature-broker-binary', './feature/supermoderation_broker',
            '--feature-conf', './feature/config.yaml',
            '--feature-service-conf-dir', './feature/service_confs',

            '--input-table', self.Parameters.input_table,
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--yt-test-dir', '//home/modadvert/test/supermoderation_b2b',
        ]

        self.run_command(b2b_command, log_prefix='b2b')
