# -*- coding: utf-8 -*-
from sandbox import sdk2
import sandbox.common.types.client as ctc

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertSupermoderationInstanceCreator(modadvert.ModadvertBaseYtTask):

    name = "MODADVERT_SUPERMODERATION_INSTANCE_CREATOR"

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):

        with sdk2.parameters.Group('Binary') as binary_group:
            binary_sm_database_creator = sdk2.parameters.Resource(
                'Resource with sm database creator',
                resource_type=resource_types.MODADVERT_CREATE_SM_DATABASE_BINARY,
                required=True
            )
            binary_test_requests_generator = sdk2.parameters.Resource(
                'Resource with test requests generator',
                resource_type=resource_types.MODADVERT_RUN_TEST_REQUESTS_BINARY,
                required=True
            )
            binary_save_sm_results = sdk2.parameters.Resource(
                'Resource with SM results saver',
                resource_type=resource_types.MODADVERT_SAVE_SM_RESULTS_BINARY,
                required=True
            )
            binary_diff_sm_results = sdk2.parameters.Resource(
                'Resource with diff SM results',
                resource_type=resource_types.MODADVERT_DIFF_SM_RESULTS_BINARY,
                required=True
            )

        with sdk2.parameters.Group('Database tables params') as tables_group:
            yt_proxy_url = sdk2.parameters.String(
                'Yt main cluster',
                required=True,
                default='markov',
            )
            sync_cluster = sdk2.parameters.String(
                'Yt sync cluster',
                required=True,
                default='hahn'
            )
            async_cluster = sdk2.parameters.String(
                'Yt async cluster',
                required=True,
                default='arnold'
            )
            src_dir = sdk2.parameters.String(
                'Source yt directory',
                required=True,
                default='//home/modadvert/test'
            )
            old_db_dir = sdk2.parameters.String(
                'Base database directory',
                required=True,
                default='//home/modadvert/test/dev/supermoderation'
            )
            new_db_dir = sdk2.parameters.String(
                'Feature database directory',
                required=True,
                default='//home/modadvert/test/dev2/supermoderation'
            )
            original_dir = sdk2.parameters.String(
                'Original supermoderation DB dir',
                default='//home/modadvert/supermoderation'
            )

        with sdk2.parameters.Group('Test requests params') as requests_group:
            workers_count = sdk2.parameters.Integer(
                'Workers count',
                required=True,
                default=5
            )
            old_url = sdk2.parameters.String(
                'Requests base URL',
                required=True,
                default='http://dev.modadvert-test.yandex-team.ru/'
            )
            new_url = sdk2.parameters.String(
                'Requests feature URL',
                required=True,
                default='http://dev2.modadvert-test.yandex-team.ru/'
            )
            old_log_table = sdk2.parameters.String(
                'Requests base log table',
                required=True,
                default='//home/modadvert/test/old_log_table'
            )
            new_log_table = sdk2.parameters.String(
                'Requests ferature log table',
                required=True,
                default='//home/modadvert/test/new_log_table'
            )
            max_rps = sdk2.parameters.Integer(
                'Limit requests per second',
                default=5
            )
            max_requests = sdk2.parameters.Integer(
                'Limit requests count',
                default=2000
            )
            table = sdk2.parameters.String(
                'Table to fire with',
                required=True,
                default='//home/modadvert/test/Requests'
            )

        with sdk2.parameters.Group('SM1 results') as sm1_results_group:
            old_save_dir = sdk2.parameters.String(
                'dir to save base supermoderation results',
                required=True,
                default='//home/modadvert/test/base_db_save'
            )

        with sdk2.parameters.Group('SM2 results') as sm2_results_group:
            new_save_dir = sdk2.parameters.String(
                'dir to save feature supermoderation results',
                required=True,
                default='//home/modadvert/test/feature_db_save'
            )

        with sdk2.parameters.Group('Database differ params') as differ_group:
            table_diff_dir = sdk2.parameters.String(
                'Yt destination diff directory',
                required=True,
                default='//home/modadvert/test/base_and_feature_diff'
            )

    def on_execute_inner(self):
        if not self.Context.run_sm_base_database_creator:
            self.Context.run_sm_base_database_creator = self.create_subtask(
                'MODADVERT_CREATE_SM_DATABASE',
                input_parameters={
                    'yt_proxy_url': self.Parameters.yt_proxy_url,
                    'sync_cluster': self.Parameters.sync_cluster,
                    'async_cluster': self.Parameters.async_cluster,
                    'src_dir': self.Parameters.src_dir,
                    'dst_dir': self.Parameters.old_db_dir,
                    'original_dir': self.Parameters.original_dir,
                    'binaries_resource': self.Parameters.binary_sm_database_creator
                }
            )
        if not self.Context.run_sm_feature_database_creator:
            self.Context.run_sm_feature_database_creator = self.create_subtask(
                'MODADVERT_CREATE_SM_DATABASE',
                input_parameters={
                    'yt_proxy_url': self.Parameters.yt_proxy_url,
                    'sync_cluster': self.Parameters.sync_cluster,
                    'async_cluster': self.Parameters.async_cluster,
                    'src_dir': self.Parameters.src_dir,
                    'dst_dir': self.Parameters.new_db_dir,
                    'original_dir': self.Parameters.original_dir,
                    'binaries_resource': self.Parameters.binary_sm_database_creator
                }
            )

        self.wait_all_subtasks()

        if not self.Context.base_test_requester:
            self.Context.base_test_requester = self.create_subtask(
                'MODADVERT_RUN_TEST_REQUESTS',
                input_parameters={
                    'yt_proxy_url': self.Parameters.sync_cluster,
                    'workers_count': self.Parameters.workers_count,
                    'url': self.Parameters.old_url,
                    'log_table': self.Parameters.old_log_table,
                    'max_requests': self.Parameters.max_requests,
                    'max_rps': self.Parameters.max_rps,
                    'table': self.Parameters.table,
                    'binaries_resource': self.Parameters.binary_test_requests_generator
                }
            )

        if not self.Context.feature_test_requester:
            self.Context.feature_test_requester = self.create_subtask(
                'MODADVERT_RUN_TEST_REQUESTS',
                input_parameters={
                    'yt_proxy_url': self.Parameters.sync_cluster,
                    'workers_count': self.Parameters.workers_count,
                    'url': self.Parameters.new_url,
                    'log_table': self.Parameters.new_log_table,
                    'max_requests': self.Parameters.max_requests,
                    'max_rps': self.Parameters.max_rps,
                    'table': self.Parameters.table,
                    'binaries_resource': self.Parameters.binary_test_requests_generator
                }
            )

        self.wait_all_subtasks()
        if not self.Context.wait_timer:
            self.Context.wait_timer = 12
            raise sdk2.WaitTime(600)

        if not self.Context.base_results_saver:
            self.Context.base_results_saver = self.create_subtask(
                'MODADVERT_SAVE_SM_RESULTS',
                input_parameters={
                    'yt_proxy_url': self.Parameters.sync_cluster,
                    'src_dir': self.Parameters.old_db_dir,
                    'dst_dir': self.Parameters.old_save_dir,
                    'log_table': self.Parameters.old_log_table,
                    'binaries_resource': self.Parameters.binary_save_sm_results
                }
            )

        if not self.Context.feature_results_saver:
            self.Context.feature_results_saver = self.create_subtask(
                'MODADVERT_SAVE_SM_RESULTS',
                input_parameters={
                    'yt_proxy_url': self.Parameters.sync_cluster,
                    'src_dir': self.Parameters.new_db_dir,
                    'dst_dir': self.Parameters.new_save_dir,
                    'log_table': self.Parameters.new_log_table,
                    'binaries_resource': self.Parameters.binary_save_sm_results
                }
            )

        self.wait_all_subtasks()

        if not self.Context.results_differ:
            self.Context.results_differ = self.create_subtask(
                'MODADVERT_DIFF_SM_RESULTS',
                input_parameters={
                    'yt_proxy_url': self.Parameters.sync_cluster,
                    'base_sm_dir': self.Parameters.old_save_dir,
                    'feature_sm_dir': self.Parameters.new_save_dir,
                    'base_req_log': self.Parameters.old_save_dir + '/LOG',
                    'feature_req_log': self.Parameters.new_save_dir + '/LOG',
                    'table_diff_dir': self.Parameters.table_diff_dir,
                    'binaries_resource': self.Parameters.binary_diff_sm_results
                }
            )

        self.wait_all_subtasks()
