# -*- coding: utf-8 -*-
import logging
import sandbox.common.types.client as ctc
import sandbox.sandboxsdk.parameters as sdk_parameters
import sandbox.sandboxsdk.task as sdk_task

from sandbox.projects.common import apihelpers
from sandbox.projects.modadvert import resource_types

YQL_DEFAULT_QUERY = """USE hahn;
PRAGMA inferscheme;
SELECT
    COUNT(*)
FROM
    [//home/modadvert/toloka/direct_texts/completed/Total]
WHERE
    submitTs BETWEEN {} AND {}
;"""


class ModadvertTolokaAutobudget(sdk_task.SandboxTask):
    type = "MODADVERT_TOLOKA_AUTOBUDGET"
    client_tags = ctc.Tag.LINUX_PRECISE
    cores = 1
    required_ram = 4096
    execution_space = 10 * 1024

    class YtProxyUrl(sdk_parameters.SandboxStringParameter):
        name = "yt_proxy_url"
        description = name
        default_value = "hahn.yt.yandex.net"

    class VaultUser(sdk_parameters.SandboxStringParameter):
        name = "vault_user"
        description = name
        default_value = "MODADVERT"

    class YtTokenVaultName(sdk_parameters.SandboxStringParameter):
        name = "yt_token_vault_name"
        description = name
        default_value = "yt-token"

    class YqlTokenVaultName(sdk_parameters.SandboxStringParameter):
        name = "yql_token_vault_name"
        description = name
        default_value = "yql-token"

    class KarmaQuantilesTable(sdk_parameters.SandboxStringParameter):
        name = "karma_quantiles_table"
        description = name
        default_value = "//home/modadvert/TolokaAutobudget/BannerKarmaQuantiles"

    class BannersCountTable(sdk_parameters.SandboxStringParameter):
        name = "banners_count_table"
        description = name
        default_value = "//home/modadvert/TolokaAutobudget/BannersCount"

    class ThresholdNode(sdk_parameters.SandboxStringParameter):
        name = "threshold_node"
        description = name
        default_value = "//home/modadvert/TolokaAutobudget/KarmaThreshold"

    class DailyLimitNode(sdk_parameters.SandboxStringParameter):
        name = "daily_limit_node"
        description = name
        default_value = "//home/modadvert/TolokaAutobudget/BannersWeeklyLimit"

    class QuantileScaleNode(sdk_parameters.SandboxStringParameter):
        name = "quantile_scale_node"
        description = name
        default_value = "//home/modadvert/TolokaAutobudget/QuantileScale"

    class YqlQuery(sdk_parameters.SandboxStringParameter):
        name = "yql_query"
        description = name
        default_value = YQL_DEFAULT_QUERY

    class WorkloadGamma(sdk_parameters.SandboxStringParameter):
        name = "workload_gamma"
        description = name
        default_value = "1"

    class ConservativeCoefficient(sdk_parameters.SandboxStringParameter):
        name = "conservative_coefficient"
        description = name
        default_value = "0.9"

    class LookupOffsetDays(sdk_parameters.SandboxIntegerParameter):
        name = "lookup_offset_days"
        description = name
        default_value = 7

    class ForecastPeriodDays(sdk_parameters.SandboxIntegerParameter):
        name = "forecast_period_days"
        description = name
        default_value = 7

    class WorkloadOffsetHours(sdk_parameters.SandboxIntegerParameter):
        name = "workload_offset_hours"
        description = name
        default_value = 24

    class WorkloadEstimateSegmentsCount(sdk_parameters.SandboxIntegerParameter):
        name = "workload_estimate_segments_count"
        description = name
        default_value = 7

    input_parameters = [
        YtProxyUrl,
        VaultUser,
        YtTokenVaultName,
        YqlTokenVaultName,
        KarmaQuantilesTable,
        BannersCountTable,
        ThresholdNode,
        DailyLimitNode,
        QuantileScaleNode,
        YqlQuery,
        WorkloadGamma,
        ConservativeCoefficient,
        LookupOffsetDays,
        ForecastPeriodDays,
        WorkloadOffsetHours,
        WorkloadEstimateSegmentsCount,
    ]

    def on_execute(self):
        logging.info("starting ModadvertTolokaAutobudget on_execute()...")
        from projects.modadvert.common.utils import run_command_with_livelog

        resource = apihelpers.get_last_resource_with_attribute(
            resource_types.YA_PACKAGE,
            "resource_name",
            "toloka-autobudget"
        )
        tarball_path = self.sync_resource(resource)

        unpack_binary_cmd = ['tar', '-xvf', tarball_path]
        update_banners_karma_cmd = [
            "./toloka_autobudget",
            "--yt-proxy-url", str(self.ctx.get(self.YtProxyUrl.name)),
            "--karma-quantiles-table", str(self.ctx.get(self.KarmaQuantilesTable.name)),
            "--banners-count-table", str(self.ctx.get(self.BannersCountTable.name)),
            "--threshold-node", str(self.ctx.get(self.ThresholdNode.name)),
            "--daily-limit-node", str(self.ctx.get(self.DailyLimitNode.name)),
            "--quantile-scale-node", str(self.ctx.get(self.QuantileScaleNode.name)),
            "--yql-query", str(self.ctx.get(self.YqlQuery.name)),
            "--workload-gamma", str(self.ctx.get(self.WorkloadGamma.name)),
            "--conservative-coefficient", str(self.ctx.get(self.ConservativeCoefficient.name)),
            "--lookup-offset-days", str(self.ctx.get(self.LookupOffsetDays.name)),
            "--forecast-period-days", str(self.ctx.get(self.ForecastPeriodDays.name)),
            "--workload-offset-hours", str(self.ctx.get(self.WorkloadOffsetHours.name)),
            "--workload-estimate-segments-count", str(self.ctx.get(self.WorkloadEstimateSegmentsCount.name)),
        ]

        run_command_with_livelog(unpack_binary_cmd)
        run_command_with_livelog(
            update_banners_karma_cmd,
            env={
                'YT_TOKEN': self.get_vault_data(self.ctx.get(self.VaultUser.name), self.ctx.get(self.YtTokenVaultName.name)),
                'YQL_TOKEN': self.get_vault_data(self.ctx.get(self.VaultUser.name), self.ctx.get(self.YqlTokenVaultName.name)),
            }
        )

        logging.info("finished ModadvertTolokaAutobudget on_execute()...")


__Task__ = ModadvertTolokaAutobudget
