# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertUpdateAbusiveBanners(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-27: Join abuses with prod-banners and prod-images.
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with update_abusive_banners binary',
                resource_type=[resource_types.MODADVERT_UPDATE_ABUSIVE_BANNERS],
                required=True
            )

        with sdk2.parameters.Group('Input options') as options_group:
            abuses_table = sdk2.parameters.String('abuses_table', default='//home/modadvert/AbusiveBanners')
            banners_table = sdk2.parameters.String('banners_table', default='//home/direct-moderate/prod-banners')
            images_table = sdk2.parameters.String('images_table', default='//home/direct-moderate/prod-images')
            dst_table = sdk2.parameters.String('dst_table', default='//home/modadvert/AbusiveBannersJoined')
            ask_url = sdk2.parameters.String(
                'ask_url',
                description='URL to perform checkRemoderateStatusAbuseBanners',
                default='http://intapi.direct-mod.yandex.ru:7080/oauth/jsonrpc/'
            )
            logging_level = modadvert.LoggingLevel('Logging level', default='DEBUG')

    def on_before_execute(self):
        super(ModadvertUpdateAbusiveBanners, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './update_abusive_banners',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--abuses-table', self.Parameters.abuses_table,
            '--banners-table', self.Parameters.banners_table,
            '--images-table', self.Parameters.images_table,
            '--dst-table', self.Parameters.dst_table,
            '--ask-url', self.Parameters.ask_url,
            '--logging-level', self.Parameters.logging_level
        ]
        self.run_command(binary_cmd)
