# -*- coding: utf-8 -*-
import logging
import sandbox.common.types.client as ctc
import sandbox.sandboxsdk.parameters as sdk_parameters
import sandbox.sandboxsdk.task as sdk_task

from sandbox.projects.common import apihelpers
from sandbox.projects.modadvert import resource_types


class ModadvertBannersKarma(sdk_task.SandboxTask):
    type = "MODADVERT_BANNERS_KARMA"
    client_tags = ctc.Tag.LINUX_PRECISE

    class YtProxyUrl(sdk_parameters.SandboxStringParameter):
        name = "yt_proxy_url"
        description = name
        default_value = "hahn.yt.yandex.net"

    class VaultUser(sdk_parameters.SandboxStringParameter):
        name = "vault_user"
        description = name
        default_value = "MODADVERT"

    class YtTokenVaultName(sdk_parameters.SandboxStringParameter):
        name = "yt_token_vault_name"
        description = name
        default_value = "yt-token"

    class SourceTable(sdk_parameters.SandboxStringParameter):
        name = "source_table"
        description = name
        default_value = "//home/direct-moderate/prod-banners"

    class OutputTable(sdk_parameters.SandboxStringParameter):
        name = "output_table"
        description = name
        default_value = "//home/modadvert/TolokaAutobudget/BannerKarmaQuantiles"

    class ClientKarmaTable(sdk_parameters.SandboxStringParameter):
        name = "client_karma_table"
        description = name
        default_value = "//home/modadvert/MxClientKarma"

    input_parameters = [
        YtProxyUrl,
        VaultUser,
        YtTokenVaultName,
        SourceTable,
        OutputTable,
        ClientKarmaTable,
    ]

    def on_execute(self):
        logging.info("starting ModadvertBannersKarma on_execute()...")
        from projects.modadvert.common.utils import run_command_with_livelog

        resource = apihelpers.get_last_resource_with_attribute(
            resource_types.YA_PACKAGE,
            "resource_name",
            "modadvert-banner-karma-quantiles-binary"
        )
        tarball_path = self.sync_resource(resource)

        unpack_binary_cmd = ['tar', '-xvf', tarball_path]
        update_banners_karma_cmd = [
            "./update_banner_karma_quantiles",
            "--yt-proxy-url", str(self.ctx.get(self.YtProxyUrl.name)),
            "--source-table", str(self.ctx.get(self.SourceTable.name)),
            "--output-table", str(self.ctx.get(self.OutputTable.name)),
            "--client-karma-table", str(self.ctx.get(self.ClientKarmaTable.name)),
        ]

        run_command_with_livelog(unpack_binary_cmd)
        run_command_with_livelog(
            update_banners_karma_cmd,
            env={
                'YT_TOKEN': self.get_vault_data(self.ctx.get(self.VaultUser.name), self.ctx.get(self.YtTokenVaultName.name)),
            }
        )

        logging.info("finished ModadvertBannersKarma on_execute()...")


__Task__ = ModadvertBannersKarma
