import logging
# import subprocess

import sandbox.common.types.client as ctc
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters
from sandbox.sandboxsdk import environments
from sandbox.common import errors


class ModadvertUpdateBannersCount(sdk_task.SandboxTask):
    type = "MODADVERT_UPDATE_BANNERS_COUNT"
    client_tags = ctc.Tag.LINUX_PRECISE
    cores = 1
    required_ram = 4096
    execution_space = 2048

    class YtProxyUrl(sdk_parameters.SandboxStringParameter):
        name = "yt_proxy_url"
        description = name
        default_value = "hahn.yt.yandex.net"

    class VaultUser(sdk_parameters.SandboxStringParameter):
        name = "vault_user"
        description = name
        default_value = "MODADVERT"

    class YtTokenVaultName(sdk_parameters.SandboxStringParameter):
        name = "yt_token_vault_name"
        description = name
        default_value = "yt-token"

    class SourceDir(sdk_parameters.SandboxStringParameter):
        name = "source_dir"
        description = name
        default_value = "//home/logfeller/logs/modadvert-requests-log/stream/5min"

    class OutputTable(sdk_parameters.SandboxStringParameter):
        name = "output_table"
        description = name
        default_value = "//home/modadvert/TolokaAutobudget/BannersCount"

    input_parameters = [
        YtProxyUrl,
        VaultUser,
        YtTokenVaultName,
        SourceDir,
        OutputTable
    ]

    environment = (
        environments.PipEnvironment('yandex-yt', '0.8.38a1', use_wheel=True),
        environments.PipEnvironment('yandex-yt-yson-bindings-skynet', use_wheel=True),
    )

    def on_execute(self):
        from . import yt_runner
        logging.info("starting ModadvertUpdateBannersCount on_execute()...")

        try:
            yt_runner.run(
                yt_proxy_url=self.ctx.get(self.YtProxyUrl.name),
                yt_token=self.get_vault_data(self.ctx.get(self.VaultUser.name), self.ctx.get(self.YtTokenVaultName.name)),
                source_dir=self.ctx.get(self.SourceDir.name),
                output_table=self.ctx.get(self.OutputTable.name)
            )
        except Exception as e:
            raise errors.TemporaryError('yt_runner failed with error: {}'.format(e))

        logging.info("finished ModadvertUpdateBannersCount on_execute()...")


__Task__ = ModadvertUpdateBannersCount
