import sandbox.common.types.client as ctc
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert


class ModadvertUpdateClientsWhiteList(modadvert.ModadvertBaseRunBinaryTask):
    """
    MODADVERT-266: Update clients white list
    """

    resource_name = 'modadvert-update-clients-white-list'

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC

    class Parameters(modadvert.ModadvertBaseRunBinaryTask.Parameters):
        handler_url = sdk2.parameters.String('Handler url', default='http://9048.ppcmoddev2.yandex-team.ru/jsonrpc/')
        high_priority_tables = sdk2.parameters.List('YT table for clients with high priority')
        medium_priority_tables = sdk2.parameters.List('YT table for clients with medium priority')

        with modadvert.ModadvertBaseRunBinaryTask.Parameters.clusters_group() as clusters_group:
            yt_worker_proxy_url = modadvert.YtCluster('YT worker cluster', default='arnold')

    def create_command(self):
        command = [
            './update_clients_white_list',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--yt-worker-proxy-url', self.Parameters.yt_worker_proxy_url,
            '--handler-url', self.Parameters.handler_url,
        ]
        command += ['--high-tables'] + (self.Parameters.high_priority_tables or [])
        command += ['--medium-tables'] + (self.Parameters.medium_priority_tables or [])
        return command
