# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertUpdateFlagsOfflineTablesManager(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-1600: Manage /source, /processing and /done tables with flags update
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with update_flags_offline_tables_manager binary',
                resource_type=[resource_types.MODADVERT_UPDATE_FLAGS_OFFLINE_TABLES_MANAGER],
                required=True
            )

        with sdk2.parameters.Group('Input options') as options_group:
            source_dir = sdk2.parameters.String('source_dir', default='//home/direct-moderate/update_flags_offline/source')
            processing_dir = sdk2.parameters.String('processing_dir', default='//home/direct-moderate/update_flags_offline/processing')
            done_dir = sdk2.parameters.String('done_dir', default='//home/direct-moderate/update_flags_offline/done')
            workers_total = sdk2.parameters.Integer('workers_total', default=30)
            max_processing_time = sdk2.parameters.Integer('max_processing_time', default=3 * 24 * 60 * 60)
            max_rows_per_table = sdk2.parameters.Integer('max_rows_per_table', default=10000)
            logging_level = modadvert.LoggingLevel('Logging level', default='DEBUG')

    def on_before_execute(self):
        super(ModadvertUpdateFlagsOfflineTablesManager, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './update_flags_offline_tables_manager',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--source-dir', self.Parameters.source_dir,
            '--processing-dir', self.Parameters.processing_dir,
            '--done-dir', self.Parameters.done_dir,
            '--workers-total', self.Parameters.workers_total,
            '--max-processing-time', self.Parameters.max_processing_time,
            '--max-rows-per-table', self.Parameters.max_rows_per_table,
            '--logging-level', self.Parameters.logging_level
        ]
        self.run_command(binary_cmd)
