# -*- coding: utf-8 -*-
import os.path
from sandbox import sdk2
import yaml

from sandbox.common.types.misc import NotExists
from sandbox.projects.modadvert import resource_types
from sandbox.projects.modadvert.common import modadvert


class ModadvertUpdateMisprintsWhiteList(modadvert.ModadvertBaseYtTask):

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):

        with sdk2.parameters.Group('Binary') as binary_group:
            binary_resource = sdk2.parameters.Resource(
                'Resource with binary',
                resource_type=resource_types.ALL_MODADVERT_TYPES
            )

        with sdk2.parameters.Group('Config') as config_group:
            config_resource = sdk2.parameters.Resource(
                'Resource with config',
                resource_type=resource_types.ALL_MODADVERT_TYPES
            )

        with sdk2.parameters.Group('Launch parameters') as launch_group:
            base_cmd = sdk2.parameters.List('Base cmd', default=['./update_misprints_white_list'], required=True)
            cmd_options = sdk2.parameters.Dict('Binary options', default={'--conf': './default_config.yaml'})
            debug = sdk2.parameters.Bool('Debug mode', default=True, required=True)
            configs_patch = sdk2.parameters.String('Yaml configs patch', multiline=True)

    def create_command(self):
        cmd = self.Parameters.base_cmd
        for pair in self.Parameters.cmd_options.iteritems():
            cmd.extend(pair)

        if self.Parameters.debug and self.Parameters.debug is not NotExists:
            cmd.append('--debug')

        return cmd

    def override_config_file(self, config_file, config_patch):
        overriden_config = {}
        if os.path.isfile(config_file):
            with open(config_file, 'r') as stream:
                overriden_config = yaml.load(stream)
        with open(config_file, 'w') as stream:
            yaml.dump(modadvert.merge_configs(config_patch, overriden_config), stream)

    def on_execute_inner(self):
        self.untar_resource(self.Parameters.binary_resource)

        if self.Parameters.config_resource and self.Parameters.config_resource is not NotExists:
            self.untar_resource(self.Parameters.config_resource)

        if self.Parameters.configs_patch:
            for config_file, config_patch in yaml.load(self.Parameters.configs_patch).iteritems():
                self.override_config_file(config_file, config_patch)

        self.run_command(self.create_command(), log_prefix='main', env=self.create_env())
