# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertWhiteListSpamClient(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-518: Create white list of client.
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with white_list_spam_client binary',
                resource_type=[resource_types.MODADVERT_WHITE_LIST_SPAM_CLIENT_BINARY],
                required=True
            )

        with modadvert.ModadvertBaseYtTask.Parameters.clusters_group() as clusters_group:
            yt_worker_proxy_url = modadvert.YtCluster('YT worker cluster', default='hahn')

        with sdk2.parameters.Group('Input options') as lyncher_results_options_group:
            verdict_log_dir = sdk2.parameters.String(
                'Verdict log dir',
                default='//logs/modadvert-supermoderation-add-verdicts-log/1d'
            )
            offset = sdk2.parameters.Integer(
                'Offset',
                default=7
            )
            types = sdk2.parameters.List(
                'supported types for turnable',
                sdk2.parameters.String,
                default=['banner', 'image', 'phrases', 'sitelinks_set', 'callout', 'display_href']
            )
            services = sdk2.parameters.List(
                'Supermoderation services with turnable mechanics',
                sdk2.parameters.String,
                default=['direct']
            )
            automod_circuits = sdk2.parameters.List(
                'List of circuits of known automoderators with turnable mechanics',
                sdk2.parameters.String,
                default=['cupid', 'lyncher']
            )
            gt_circuits = sdk2.parameters.List(
                'List of circuits of human moderators',
                sdk2.parameters.String,
                default=['admin_interface', 'yang']
            )
            offset_units = sdk2.parameters.String(
                'Offset units',
                default='days'
            )

        with sdk2.parameters.Group('Output options') as output_options_group:
            intermediate_results = sdk2.parameters.String(
                'Intermediate results table path',
                default='//home/modadvert/test/biryuk/fixlist'
            )
            table_dst = sdk2.parameters.String(
                'Destination table path',
                default='//home/modadvert/white_lists/WhiteListSpamClients'
            )

    def on_before_execute(self):
        super(ModadvertWhiteListSpamClient, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './white_list_spam_client',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--yt-worker-proxy-url', self.Parameters.yt_worker_proxy_url,
            '--verdict-log-dir', self.Parameters.verdict_log_dir,
            '--offset', self.Parameters.offset,
            '--offset-units', self.Parameters.offset_units,
            '--intermediate-results', self.Parameters.intermediate_results,
            '--table-dst', self.Parameters.table_dst,
            '--enable-rpc-proxy',
        ]
        binary_cmd.extend(['--types'] + self.Parameters.types)
        binary_cmd.extend(['--services'] + self.Parameters.services)
        binary_cmd.extend(['--automod-circuits'] + self.Parameters.automod_circuits)
        binary_cmd.extend(['--gt-circuits'] + self.Parameters.gt_circuits)
        self.run_command(binary_cmd)
