# -*- coding: utf-8 -*-
import logging
import subprocess


def run_command_with_livelog(command, env=None):

    logging.info('RUNNING COMMAND: {}'.format(command))

    # temporary change format to just message from binary
    root_logger = logging.getLogger()
    simple_formatter = logging.Formatter('%(message)s')
    prev_formatters = [handler.formatter  for handler in root_logger.handlers]
    for handler in root_logger.handlers:
        handler.formatter = simple_formatter

    try:

        proc = subprocess.Popen(
            command,
            stdout=subprocess.PIPE,
            stderr=subprocess.STDOUT,
            bufsize=1,
            env=env
        )

        with proc.stdout:
            for line in iter(proc.stdout.readline, ''):
                logging.warning(line.rstrip())

        proc.wait()

        if proc.returncode != 0:
            message = '{} failed, with status code {}'.format(command, proc.returncode)
            raise RuntimeError(message)

    finally:
        # reset formatter
        for handler, prev_formatter in zip(root_logger.handlers, prev_formatters):
            handler.formatter = prev_formatter
