# -*- coding: utf-8 -*-
import yt.wrapper as yt


def yt_connect(cluster_url, yt_token):
    yt.config.VERSION = "v3"
    yt.config["proxy"]["url"] = cluster_url
    yt.config["token"] = yt_token
    config = {
        "tabular_data_format": yt.YsonFormat(),
        "default_value_of_raw_option": False,
        "detached": False,
        "api_version": "v3",
        "token": yt_token,
        "proxy": {"url": cluster_url},
        "pickling": {
            "force_using_py_instead_of_pyc": True,
            "python_binary": '/skynet/python/bin/python'  # YT compatible python
        },
        "auto_merge_output": {
            "action": "merge"
        },
        "allow_http_requests_to_yt_from_job": True
    }

    return yt.YtClient(config=config)
