# -*- coding: utf-8 -*-
import inspect
import sys
from sandbox.projects.bigmod.resources import bigmod_releasers
from sandbox.projects.resource_types import AbstractResource, YA_PACKAGE  # noqa


modadvert_releasers = [
    'vsuvorov',
    'artemkon',
    'crazyministr',
    'dddlatyshev',
    'kpopov94',
    'turmetsmakoev',
    'granilace',
    'rinatous',
    'robot-modadvert-yt'
]


class MODADVERT_RESOURCE(AbstractResource):
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = modadvert_releasers
    release_subscribers = modadvert_releasers


class MODADVERT_CPROFILE_STATS(MODADVERT_RESOURCE):
    """
        cProfiel stats files
    """


class MODADVERT_LYNCHER_BINARIES(MODADVERT_RESOURCE):
    """
        All code for moderation service modadvert/Lyncher, packed into binaries
    """


class MODADVERT_QLYNCHER_BINARIES(MODADVERT_RESOURCE):
    """
        All code for moderation service modadvert/Lyncher, packed into binaries
    """


class MODADVERT_OFFLINE_LYNCHER_BINARIES(MODADVERT_RESOURCE):
    """
        All code for offline moderation service modadvert/Lyncher, packed into binaries
    """


class MODADVERT_LYNCHER_CONFIG(MODADVERT_RESOURCE):
    """
        Override config for moderation service modadvert/Lyncher
    """


class MODADVERT_TRANSFER_CONFIG(MODADVERT_RESOURCE):
    """
        Override transfer config for moderation service modadvert/TransferManager
    """


class MODADVERT_TRANSFER_BINARY(MODADVERT_RESOURCE):
    """
        MODADVERT-1782: rewrite transfer_manager
    """


class MODADVERT_SM_BROKER_BINARY(MODADVERT_RESOURCE):
    """
        Supermoderation Broker Binary
    """
    entry_point = './supermoderation_broker'


class MODADVERT_SM_CONFIG(MODADVERT_RESOURCE):
    """
        Supermoderation Broker Config
    """


class MODADVERT_SM_CONFIG_DEV(MODADVERT_SM_CONFIG):
    """
        Supermoderation DEVELOPMENT Broker Config
    """


class MODADVERT_SM_CONFIG_DEV_2(MODADVERT_SM_CONFIG):
    """
        Supermoderation DEVELOPMENT_2 Broker Config
    """


class MODADVERT_SM_CONFIG_STAGE(MODADVERT_SM_CONFIG):
    """
        Supermoderation STAGE Config
    """


class MODADVERT_SM_CONFIG_TESTING(MODADVERT_SM_CONFIG):
    """
        Supermoderation TESTING Broker Config
    """


class MODADVERT_SM_CONFIG_PROD(MODADVERT_SM_CONFIG):
    """
        Supermoderation PROD Broker Config
    """


class MODADVERT_SM_SERVICE_CONFIG(MODADVERT_RESOURCE):
    """
        Supermoderation Service(one of) Config
    """


class MODADVERT_SM_SERVICE_CONFIG_DEV(MODADVERT_SM_SERVICE_CONFIG):
    """
        Supermoderation DEVELOPMENT Service(one of) Config
    """


class MODADVERT_SM_SERVICE_CONFIG_STAGE(MODADVERT_SM_SERVICE_CONFIG):
    """
        Supermoderation STAGE Service(one of) Config
    """


class MODADVERT_SM_SERVICE_CONFIG_TESTING(MODADVERT_SM_SERVICE_CONFIG):
    """
        Supermoderation TESTING Service(one of) Config
    """


class MODADVERT_SM_SERVICE_CONFIG_PROD(MODADVERT_SM_SERVICE_CONFIG):
    """
        Supermoderation PRODUCTION Service(one of) Config
    """


class MODADVERT_MODERATION_ADAPTER_BINARY(MODADVERT_RESOURCE):
    """
        Supermoderation Moderation Adapter Binary
    """
    entry_point = './moderation_adapter'


class MODADVERT_CV_INDEXER_BINARY(MODADVERT_RESOURCE):
    """
        Supermoderation CV Indexer Binary
    """
    entry_point = './cv_indexer'


class MODADVERT_CLEAN_SUPERMODERATION_REQUESTS_BINARY(MODADVERT_RESOURCE):
    """
        Clean Supermoderation Requests Binary
    """
    entry_point = './clean_supermoderation_requests'


class MODADVERT_DIRECT_PROXY_BINARY(MODADVERT_RESOURCE):
    """
        Supermoderation proxy between Direct and Moderation
    """


class MODADVERT_SM_API_BINARY(MODADVERT_RESOURCE):
    """
        Supermoderation API
    """


class MODADVERT_SM_ADMIN_BINARY(MODADVERT_RESOURCE):
    """
        Supermoderation admin interface
    """


class MODADVERT_MONIKA_BINARY(MODADVERT_RESOURCE):
    """
        Monika Binary
    """


class MODADVERT_TOLOKA_NEED_CONFIG(MODADVERT_RESOURCE):
    """
       Modadvert toloka need config
    """


class MODADVERT_SUPERMODERATION_B2B_BINARY(MODADVERT_RESOURCE):
    """
        Supermoderation b2b binary
    """


class MODADVERT_BSML_MODEL(MODADVERT_RESOURCE):
    """BSML model"""


class MODADVERT_FASTML_MODEL(MODADVERT_RESOURCE):
    """FASTML model"""


class MODADVERT_DSSM_MODEL(MODADVERT_RESOURCE):
    """DSSM model"""


class MODADVERT_META_RULE_MODEL(MODADVERT_RESOURCE):
    """Meta-Rule model"""


class MODADVERT_BRANDS_CLASSIFIER(MODADVERT_RESOURCE):
    """
        Brands classifier binary
    """


class MODADVERT_BRANDS_CLASSIFIER_CIRCUIT(MODADVERT_RESOURCE):
    """
        Brands classifier circuit binary
    """
    entry_point = './brands_classifier_circuit'


class MODADVERT_CATBOOST_MULTICLASS_MODEL(MODADVERT_RESOURCE):
    """
        CatBoost model and config
    """


class MODADVERT_BRANDS_API_BINARY(MODADVERT_RESOURCE):
    """
        Brands API binary
    """


class MODADVERT_BRANDS_CONFIG(MODADVERT_RESOURCE):
    """
        Brands config
    """


class MODADVERT_BRANDS_CONFIG_TESTING(MODADVERT_BRANDS_CONFIG):
    """
        Brands TESTING config
    """


class MODADVERT_BRANDS_CONFIG_PROD(MODADVERT_BRANDS_CONFIG):
    """
        Brands PRODUCTION config
    """


class MODADVERT_SAAS_INDEXER_BINARY(MODADVERT_RESOURCE):
    """
    SaaS indexer binary
    """
    entry_point = './saas_indexer'


class MODADVERT_GREP_IMG_REJECTS(MODADVERT_RESOURCE):
    """
        Grep image rejects binary
    """


class MODADVERT_ANTISPAM_ADAPTER_BINARY(MODADVERT_RESOURCE):
    """
    Antispam adapter binary
    """
    entry_point = './antispam_adapter'


class MODADVERT_ANTISPAM_REVERSE_ADAPTER_BINARY(MODADVERT_RESOURCE):
    """
    Antispam reverse adapter binary
    """
    entry_point = './antispam_reverse_adapter'


class MODADVERT_CV_REJECTED_METRICS(MODADVERT_RESOURCE):
    """
        CV Rejected Metrics binary
    """


class MODADVERT_ABUSE_LOGS_PROCESSOR(MODADVERT_RESOURCE):
    """
        BS abuse logs processor binary
    """


class MODADVERT_ABUSE_DAILY_AGGREGATOR(MODADVERT_RESOURCE):
    """
        Abuse daily aggregator binary
    """


class MODADVERT_ABUSE_LYNCHER_RESULTS_GREPPER(MODADVERT_RESOURCE):
    """
        Abuse Lyncher results grepper binary
    """


class MODADVERT_BS_PRIORITY_THRESHOLD(MODADVERT_RESOURCE):
    """
        Priority thresholds writer binary
    """


class MODADVERT_LYNCHER_REPORT_VERDICT_BINARY(MODADVERT_RESOURCE):
    """
        Lyncher report verdicts binary
    """


class MODADVERT_MORDA_CLUSTERING_BINARY(MODADVERT_RESOURCE):
    """
        Morda clustering binary
    """


class MODADVERT_WHITE_LIST_SPAM_CLIENT_BINARY(MODADVERT_RESOURCE):
    """
        False positive clients grepper binary
    """


class MODADVERT_RUN_TEST_REQUESTS_BINARY(MODADVERT_RESOURCE):
    """
        Test requests binary
    """


class MODADVERT_CREATE_SM_DATABASE_BINARY(MODADVERT_RESOURCE):
    """
        Create test tables binary
    """


class MODADVERT_CREATE_SM_STATIC_TABLES_BINARY(MODADVERT_RESOURCE):
    """
        Create static tables binary
    """


class MODADVERT_SAVE_SM_RESULTS_BINARY(MODADVERT_RESOURCE):
    """
        Save dynamic tables into static
    """


class MODADVERT_DIFF_SM_RESULTS_BINARY(MODADVERT_RESOURCE):
    """
        Diff tables from sm results
    """


class MODADVERT_LOGS_CHUNK_MERGER(MODADVERT_RESOURCE):
    """
        Merge supermoderation logs
    """


class MODADVERT_CLEAN_DATA_BINARY(MODADVERT_RESOURCE):
    """
        MODADVERT-894: Binary file with the corresponding config to clean up data in different clusters.
    """


class MODADVERT_REPLICA_SWITCHER(MODADVERT_RESOURCE):
    """
        MODADVERT-1571: Switch YT replicas.
    """


class MODADVERT_MINUS_REGIONS_CONFIG(MODADVERT_RESOURCE):
    """
        MODADVERT-1683: Upload minus regions configuration to sandbox
    """


class MODADVERT_DYN_DISCLAIMERS_CONFIG(MODADVERT_RESOURCE):
    """
        MODADVERT-1683: Upload minus regions configuration to sandbox
    """


class MODADVERT_AD_WARNS_CONFIG(MODADVERT_RESOURCE):
    """
        MODADVERT-1683: Upload ad_warns configuration to sandbox
    """


class MODADVERT_GET_MANUALLY_MODERATED_REJECTS_BINARY(MODADVERT_RESOURCE):
    """
        MODADVERT-1772: rewrite grep_human_verified_rejects on Base Program
    """


class MODADVERT_UPDATE_ABUSIVE_BANNERS(MODADVERT_RESOURCE):
    """
        MODADVERT-27: Join abuses with prod-banners and prod-images.
    """


class MODADVERT_SPAM_NGRAMS_FINDER_BINARY(MODADVERT_RESOURCE):
    """
        MODADVERT-50: Calculate ngram statistics.
    """


class MODADVERT_UPDATE_FLAGS_OFFLINE_TABLES_MANAGER(MODADVERT_RESOURCE):
    """
        MODADVERT-1600: Manage update flags offline tables.
    """


class MODADVERT_SEND_CIRCUIT_LOG_METRICS_BINARY(MODADVERT_RESOURCE):
    """
        MODADVERT-1526: Lyncher verdicts rules graphics.
    """


class MODADVERT_LICENSES_DYNAMIC_INSERTER(MODADVERT_RESOURCE):
    """
        MODADVERT-1926: Copy licenses into dynamic.
    """


class MODADVERT_ANTIVIR_VERDICTS_LAG_METRICS(MODADVERT_RESOURCE):
    """
        MODDEV-376: Antivir verdict pass time metrics.
    """


class MODADVERT_DYNAMIC_TABLE_INSERTER_BINARY(MODADVERT_RESOURCE):
    """
        MODDEV-630: Copy table rows to dynamic table.
    """


class MODADVERT_CONFIGURATOR_BINARY(MODADVERT_RESOURCE):
    """
        MODDEV-1043: Configurator
    """


class MODADVERT_CONFIGURATOR_IN_MEMORY_CONFIGS(MODADVERT_RESOURCE):
    """
        MODDEV-1043: Configurator InMemoryConfigs (flags, threats, etc)
    """


class MODADVERT_LAAS_IN_MEMORY_RUNNER_BINARY(MODADVERT_RESOURCE):
    """
        LaaS in Memory Runner binary. See modadvert/nirvana/laas/runner
    """
    releasers = MODADVERT_RESOURCE.releasers + ['robot-modadvert-test']


class MODADVERT_LAAS_HTTP_RUNNER_BINARY(MODADVERT_RESOURCE):
    """
        LaaS HTTP Runner binary. See modadvert/programs/laas/http_runner
    """
    releasers = MODADVERT_RESOURCE.releasers + ['robot-modadvert-test']


class MODADVERT_LAAS_MR_RUNNER_BINARY(MODADVERT_RESOURCE):
    """
        LaaS MR Runner binary. See modadvert/programs/laas/mr_runner
    """
    releasers = MODADVERT_RESOURCE.releasers + ['robot-modadvert-test']


class MODADVERT_HTTP_ENVIRONMENT_IMAGE(MODADVERT_RESOURCE):
    """
        Docker image compatible with http runner. See modadvert/docker/http_environment
    """


class MODADVERT_CUPID_HTTP_ENVIRONMENT_IMAGE(MODADVERT_HTTP_ENVIRONMENT_IMAGE):
    """
        Docker image for Cupid HTTP runner. It is created specifically for PushDockerImage task
    """


class MODADVERT_MULTIK_MODEL_APPLY_BINARY(MODADVERT_RESOURCE):
    """
        MODDEV-1651: Upload Multik base DSSM model binary to sandbox
    """
    releasers = MODADVERT_RESOURCE.releasers + ['robot-modquality-ml']


class MODADVERT_MULTIK_KNN_INDEX_BINARY(MODADVERT_RESOURCE):
    """
        MODDEV-1651: Upload Multik knn-index binary to sandbox
    """
    releasers = MODADVERT_RESOURCE.releasers + ['robot-modquality-ml']


class MODADVERT_CV_APP_BINARY(MODADVERT_RESOURCE):
    """
        MODDEV-2289: Binary for cv_app.
    """


class MODADVERT_CV_APP_MODELS(MODADVERT_RESOURCE):
    """
        MODDEV-2289: Models resource for cv_app.
    """


class MODADVERT_XLS_RESULTS(MODADVERT_RESOURCE):
    """
        MODDEV-1969: Xls remoderation
    """


class MODADVERT_BIGMOD_YQL_UDF(MODADVERT_RESOURCE):
    """
        BIGMOD-206: Modadvert Bigmod YQL UDFs
    """
    releasers = sorted(set(MODADVERT_RESOURCE.releasers + bigmod_releasers))


BRANDS_CONFIG_TYPES = [
    MODADVERT_BRANDS_CONFIG,
    MODADVERT_BRANDS_CONFIG_TESTING,
    MODADVERT_BRANDS_CONFIG_PROD,
]
SUPERMODERATION_CONFIG_TYPES = [
    MODADVERT_SM_CONFIG,
    MODADVERT_SM_CONFIG_DEV,
    MODADVERT_SM_CONFIG_DEV_2,
    MODADVERT_SM_CONFIG_TESTING,
    MODADVERT_SM_CONFIG_PROD,
]
SUPERMODERATION_SERVICE_CONFIG_TYPES = [
    MODADVERT_SM_SERVICE_CONFIG,
    MODADVERT_SM_SERVICE_CONFIG_DEV,
    MODADVERT_SM_SERVICE_CONFIG_TESTING,
    MODADVERT_SM_SERVICE_CONFIG_PROD,
]


def is_modadvert_type(cls):
    return inspect.isclass(cls) and issubclass(cls, MODADVERT_RESOURCE)


ALL_MODADVERT_TYPES = [YA_PACKAGE] + [m[1] for m in inspect.getmembers(sys.modules[__name__], is_modadvert_type)]
