import logging
from sandbox.projects.msearch.common.context import ReclusterCtx
from sandbox import common
import json


class CheckReclusterPhase1(ReclusterCtx):

    """
    How to run from console:
msearch-trusty-dev:~/dev_sand/sandbox/projects/msearch/MailCheckRecluster $
cd ~/dev_sand
source ~/dev_sand/runtime_data/venv/bin/activate
~/dev_sand/runtime_data/venv/bin/python2.7
from sandbox import sdk2
from sandbox import common
from sandbox.sandboxsdk import environments
import logging
import sys
sys.path.append("/home/okkk/dev_sand/runtime_data/venv/lib/python2.7")

import logging
import sys
from copy import deepcopy
logging.basicConfig(stream=sys.stdout, level=logging.DEBUG)
logging.info("Recluster revision")

from yasmapi import GolovanRequest
from sandbox.projects.msearch.MailCheckRecluster.steps import CheckReclusterPhase1,CheckReclusterPhase2,CheckReclusterPhase3

import json, time
import requests
from requests.packages.urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

oauth_token=""
Phase1 = CheckReclusterPhase1(oauth_token=oauth_token, yasmapi=GolovanRequest, dryrun = True, force=False)
mage_last_rev = Phase1.run()

Phase2 = CheckReclusterPhase2(oauth_token=oauth_token, mage_last_rev=mage_last_rev, dryrun=True)
snapshots_for_activate = Phase2.run()
Phase3 = CheckReclusterPhase3(oauth_token=oauth_token, mage_last_rev=mage_last_rev, snapshots_for_activate=snapshots_for_activate, dryrun=True)
check_status = Phase3.run()
    """

    def __init__(self, oauth_token=False, yasmapi=None, dryrun=True, force=False):
        super(CheckReclusterPhase1, self).__init__()
        logging.info("CheckReclusterPhase1 prepare initialization")
        self.oauth_token = oauth_token
        self.yasmapi = yasmapi
        self.dryrun = dryrun
        self.force = force

    def run(self):
        # Some checks here
        # 0. Mage checks - check that recluster in mage in finished_recluster state
        # 1. yasm checks (5xx for kamaji < 5rps, copied percentage > 99, copy rate < 100mb) for all groups
        # 2. Check that this revision exists on nanny cluster
        # 3. serchmap check? that all prev instances existing in new decluster map.

        # returned revision from mage?

        logging.info("CheckRecluster Phase 1 is starting.")

        mage_last_rev_status = self.get_mage_last_revision(self.mage_url)

        # 1. Mage check
        if not mage_last_rev_status and not self.dryrun:
            raise common.errors.TaskFailure("Mage ruchkas return error. "
                                            "Exiting. "
                                            "Details: {0}".format(str(mage_last_rev_status)))
        elif self.dryrun:
            if not mage_last_rev_status:
                logging.info(
                    'Dryrun fake. Mage ruchkas return error. Continue because dryrun. '
                    'Details: {0}'.format(str(mage_last_rev_status)))
            else:
                logging.info('Dryrun fake. Mage ruchkas return SUCCESS. Continue. '
                             'Details: {0}'.format(str(mage_last_rev_status)))

        logging.info('Mage get last rev: {0}'.format(str(mage_last_rev_status)))

        if mage_last_rev_status['status'] != 'finished_recluster':
            logging.info("Previous reclusterization in {0} state. "
                         "But we need 'finished_recluster' state if we want continue. "
                         "Exiting.".format(str(mage_last_rev_status)))
            if not self.dryrun and not self.force:
                raise common.errors.TaskFailure("Previous reclusterization in {0} state. "
                                                "But we need 'finished_recluster' state if we want continue. "
                                                "Exiting.".format(str(mage_last_rev_status)))
            else:
                logging.info("Lastrev status mage return {0}, but dryrun or force option reached. "
                             "Continue.".format(str(mage_last_rev_status)))
                checked_last_rev = mage_last_rev_status['revision']
        else:
            logging.info("Mage last rev check passed. Status:{0}".format(str(mage_last_rev_status)))
            checked_last_rev = mage_last_rev_status['revision']

        # 2. Yasm check
        check_yasm_signals_prestable = self.yasm_check("prestable")
        if not check_yasm_signals_prestable:
            if not self.dryrun and not self.force:
                raise common.errors.TaskFailure("Yasm prestable checks return False")
            else:
                logging.info("Yasm prestable checks return False, but dryrun or force option reached. Continue.")
        else:
            logging.info("Yasm prestable checks passed.")

        check_yasm_signals_prod = self.yasm_check("prod")
        if not check_yasm_signals_prod:
            if not self.dryrun and not self.force:
                raise common.errors.TaskFailure("Yasm prod checks return False")
            else:
                logging.info("Yasm prod checks return False, but dryrun or force option reached. Continue.")
        else:
            logging.info("Yasm prod checks passed.")

        # 3. Nanny releases check (check for stateful services - mail search backend only)

        for group in self.nanny_groups:
            # check for every group separately
            cur_releases = self.get_gencfg_releases([group])
            rev_flag = False
            for rev in cur_releases[group]:
                if rev.split("/")[1] == checked_last_rev:
                    rev_flag = True
            if not rev_flag:
                raise common.errors.TaskFailure("Rev for decluster: {0} "
                                                "does not finded in nanny group: {1}".format(checked_last_rev, group))
                # ALWAYS MUST RETURN FALSE
                # if not self.dryrun:
                #    return False
                # else:
                #    logging.info("Nanny release checks return False, but dryrun reached. Continue.")
            else:
                logging.info("Nanny releases check passed for group: {0}".format(group))

        # 4. Nanny state check
        if not self.check_nanny_active(self.push_rev_nanny_groups):
            raise common.errors.TaskFailure("Cannot continue. "
                                            "Last revision in groups: {0} must be in ACTIVE or ACTIVATING state."
                                            .format(self.nanny_groups))

        gencfg_nanny_releases = self.get_gencfg_releases(self.nanny_groups)
        nanny_uniq_release = self.check_gencfg_nanny_releases(gencfg_nanny_releases)

        # if there one release for nanny groups we must exit witj False

        if nanny_uniq_release:
            raise common.errors.TaskFailure("ERROR! Only one nanny rev found. "
                                            "We must add reclsuter revision before we can continue. "
                                            "Aborting. {0}".format(gencfg_nanny_releases))
        else:
            logging.info("Nanny uniq release check passed.")

        return checked_last_rev


class CheckReclusterPhase2(ReclusterCtx):

    def __init__(self, oauth_token=False, mage_last_rev=False, dryrun=True):
        logging.info("DeclusterPreparePhase2 prepare initialization")
        super(CheckReclusterPhase2, self).__init__()
        self.oauth_token = oauth_token
        self.mage_last_rev = mage_last_rev
        self.dryrun = dryrun

    def run(self):
        # TODO: what revision return check reclsuter phase1 ?
        logging.info("Check recluster Phase 2 is starting. "
                     "We push revision changes for all services specified in push_rev_nanny_groups")

        if not self.mage_last_rev:
            raise common.errors.TaskFailure("Gencfg last revision for decluster is not specified. Aborting.")

        update_nanny_files_url = "{nanny_url}services/{servicename}/runtime_attrs/resources/files/static_files/"

        decluster_rev = "{0}:tags/{1}".format(self.searchmap_prefix, self.mage_last_rev)
        logging.info("Decluster revision is: {0}".format(decluster_rev))

        revision_mail_json_upd = {"comment": "Sandbox auto task update {0}".format(self.revision_filename),
                                  "url": update_nanny_files_url,
                                  "meta": {},
                                  "oauth_token": self.oauth_token,
                                  "put":
                                      {
                                          "content": {"local_path": self.revision_filename,
                                                      "content": decluster_rev,
                                                      "is_dynamic": False,
                                                      "extract_path": ""},
                                          "comment": "Sandbox auto decluster task. "
                                                     "Update {0} to: {1}".format(self.revision_filename,
                                                                                 decluster_rev),
                                          "meta_info": {"is_disposable": False}
                                      }
                                  }

        # Update self.revision_filename
        snapshots_for_activate = {}
        try:
            for service in self.push_rev_nanny_groups:
                logging.info("Starting step:{0}".format(revision_mail_json_upd['comment']))
                oauth_token = None

                if revision_mail_json_upd.get("oauth_token", False):
                    oauth_token = revision_mail_json_upd.get("oauth_token")
                # Do not do nothing if dryrun - only logging
                # TODO: move dryrun logic into make_auth_req function
                if not self.dryrun:
                    logging.info("Url: {0}, Action: put, Content: {1}".format(
                        revision_mail_json_upd["url"].format(nanny_url=self.nanny_url,
                                                             servicename=service),
                        revision_mail_json_upd.get("put", False)))

                    ret = self.make_auth_req(revision_mail_json_upd["url"].format(nanny_url=self.nanny_url,
                                                                                  servicename=service),
                                             token=oauth_token,
                                             put=revision_mail_json_upd.get("put", False),
                                             timeout=900)
                else:
                    logging.info("Dryrun fake. Url: {0}, Action: put, Content: {1}".format(
                        revision_mail_json_upd["url"].format(nanny_url=self.nanny_url,
                                                             servicename=service),
                        revision_mail_json_upd.get("put", False)))
                    ret = '{"runtime_attrs":{"_id": "dry_run_test_data"}}'

                if not ret:
                    raise common.errors.TaskFailure("Nanny request failed. Update file to decluster rev failed.")

                logging.info("Step:{0} completed.".format(revision_mail_json_upd['comment']))

                snapshots_for_activate[service] = json.loads(ret)['runtime_attrs']['_id']

        except Exception as e:
            raise common.errors.TaskFailure("Cannot decluster hosts. Aborting. Error:{0}".format(e))

        # TODO: we dont update groups revision here. Maybe in future we need to do that.

        return snapshots_for_activate


class CheckReclusterPhase3(ReclusterCtx):

    def __init__(self, oauth_token=False, mage_last_rev=False, snapshots_for_activate={}, dryrun=True):
        logging.info("DelusterPreparePhase3 prepare initialization")
        super(CheckReclusterPhase3, self).__init__()
        self.oauth_token = oauth_token
        self.snapshots_for_activate = snapshots_for_activate
        self.mage_last_rev = mage_last_rev
        self.dryrun = dryrun

    def run(self):
        # Decluster phase 3 - activate reclustered instances

        logging.info("CheckRecluster Phase 3 is starting.")
        logging.info("Snapshot for activate: {0}".format(self.snapshots_for_activate))

        activate_nanny_url = "{nanny_url}services/{servicename}/events/"
        try:
            for service in self.push_rev_nanny_groups:
                logging.info("Try to activate service {0} with snapshot_id {1}.".format(service,
                                                                                        self.snapshots_for_activate[service]))

                post = {
                    'content': {
                        'snapshot_id': "{0}".format(self.snapshots_for_activate[service]),
                        'state': 'ACTIVE',
                        'comment': 'Sandbox auto task. Decluster. Activate {0} snapshot!'.format(
                            self.snapshots_for_activate[service]),
                        'recipe': "common"},
                    'type': 'SET_SNAPSHOT_STATE'
                }

                if not self.dryrun:
                    logging.info("Url: {0}, Action: put, Content: {1}".format(
                        activate_nanny_url.format(nanny_url=self.nanny_url,
                                                  servicename=service),
                        post))
                    ret = self.make_auth_req(activate_nanny_url.format(nanny_url=self.nanny_url,
                                                                       servicename=service),
                                             token=self.oauth_token,
                                             post=post,
                                             timeout=900)
                else:
                    logging.info("Dryrun fake. Url: {0}, Action: put, Content: {1}".format(activate_nanny_url.format(nanny_url=self.nanny_url,
                                                                                                                     servicename=service),
                                                                                           post))

                    ret = True
                if not ret:
                    raise common.errors.TaskFailure("Nanny request failed. "
                                                    "Cannot SET_SNAPSHOT_STATE to ACTIVE for nanny groups.")

                logging.info("Activating for service {0} with snapshot_id {1} completed.".format(service,
                                                                                                 self.snapshots_for_activate[service]))

        except Exception as e:
            raise common.errors.TaskFailure("Cannot finish CheckRecluster. Aborting. Error:{0}".format(e))

        logging.info("CheckRecluster Phase 3 is finished. Hosts going to update now.")

        # Set that decluster is finished, if we cannot set it - recluster will be not started.

        # TODO: set only status - we dont need revision here

        if not self.dryrun:
            mage_set_last_rev_status = self.set_mage_last_revision(self.mage_url,
                                                                   self.mage_last_rev,
                                                                   'recluster_checked')
        else:
            logging.info("Dryrun fake. Set mage_set_last_status to:{0}".format('recluster_checked'))
            mage_set_last_rev_status = "dryrun"

        if not mage_set_last_rev_status:
            logging.info("Cannot set mage rev status to finished. Exiting. Details:{0}"
                         .format(mage_set_last_rev_status))
            raise common.errors.TaskFailure("Cannot set mage rev status to finished. "
                                            "Exiting. "
                                            "Details:{0}".format(mage_set_last_rev_status))

        return True
