from sandbox import sdk2
from sandbox import common
from sandbox.sandboxsdk import environments
import logging

from steps import DeclusterPreparePhase1, DeclusterPreparePhase2, DeclusterPreparePhase3


class MailDecluster(sdk2.Task):
    """ Mail Decluster task - do decluster for mail_search in RTC cloud. """

    class Parameters(sdk2.Task.Parameters):
        # common parameters
        kill_timeout = 3600

        # custom parameters
        name = sdk2.parameters.String("Your name", default="okkk", required=True)
        secret_name = sdk2.parameters.String("Secret name", default="mage_oauth", required=True)
        dryrun = sdk2.parameters.Bool("Dryrun", default=True, required=True)
        force = sdk2.parameters.Bool("Specify if you want pass monitoring checks.", default=False, required=True)

        telegram_token_vault_name = sdk2.parameters.String("TelegramBot Token vault name", default="telegram_token",
                                                           required=True)
        chat_id = sdk2.parameters.Integer("Chat ID", default=-1001222981673, required=True)

    class Requirements(sdk2.Task.Requirements):
        environments = (environments.PipEnvironment('requests'),
                        environments.PipEnvironment('yasmapi'))

    def on_execute(self):
        oauth_token = sdk2.Vault.data(self.Parameters.name, self.Parameters.secret_name)
        self.telegram_token = sdk2.task.Vault.data(self.author, self.Parameters.telegram_token_vault_name)

        bot = common.telegram.TelegramBot(self.telegram_token)

        bot.send_message(self.Parameters.chat_id, "Sandbox task STARTED: {what} "
                                                  "Description: {desc} "
                                                  "Owner: {owner} "
                                                  "Force mode (pass monitoring checks): {force} "
                                                  "Dryrun: {dryrun}".format(what=str(self.__class__.__name__),
                                                                            desc=self.Parameters.description,
                                                                            owner=self.Parameters.owner,
                                                                            force=self.Parameters.force,
                                                                            dryrun=self.Parameters.dryrun))

        logging.info("Hello, %s!", self.Parameters.name)

        try:
            from yasmapi import GolovanRequest
            Phase1 = DeclusterPreparePhase1(oauth_token=oauth_token,
                                            yasmapi=GolovanRequest,
                                            dryrun=self.Parameters.dryrun,
                                            force=self.Parameters.force)

            mage_last_rev = Phase1.run()

            Phase2 = DeclusterPreparePhase2(oauth_token=oauth_token,
                                            mage_last_rev=mage_last_rev,
                                            dryrun=self.Parameters.dryrun)

            snapshots_for_activate = Phase2.run()

            Phase3 = DeclusterPreparePhase3(oauth_token=oauth_token,
                                            mage_last_rev=mage_last_rev,
                                            snapshots_for_activate=snapshots_for_activate,
                                            dryrun=self.Parameters.dryrun)

            Phase3.run()

        except Exception as e:
            logging.info("Exception reached. Exception: {0} Detail:{1}".format(e, e.message))
            bot.send_message(self.Parameters.chat_id,
                             "Sandbox task ERROR: {what} Exception: {error}".format(what=str(self.__class__.__name__),
                                                                                    error=e))
            raise common.errors.TaskFailure("Exception reached. Exception: {0} Detail:{1}"
                                            .format(e, e.message))

        logging.info(
            "{0} completed with SUCCESS! "
            "Now another task migrates the cluster to the recluster revision.".format(str(self.__class__.__name__)))

        bot.send_message(self.Parameters.chat_id,
                         "Sandbox task finished with SUCCESS: {what}".format(what=str(self.__class__.__name__)))
