from sandbox import sdk2
from sandbox import common
from sandbox.sandboxsdk import environments
import sandbox.common.types.notification as ctn
import logging

import requests


class PsSearchBackupTask(sdk2.Task):
    """ PsSearchBackupTask - add backup slot for specified config to the meta-server. """

    class Parameters(sdk2.Task.Parameters):
        # common parameters
        kill_timeout = 3600

        # custom parameters
        config = sdk2.parameters.String("Config", required=True)
        backpackurl = sdk2.parameters.String("Backpack url",
                                             default="http://backpack-meta.mail.yandex.net/v1/slot/add",
                                             required=True)
        # secret_name = sdk2.parameters.String("Secret name", default="mage_oauth", required=True)
        # dryrun = sdk2.parameters.Bool("Dryrun", default=True, required=True)
        # force = sdk2.parameters.Bool("Force recluster (rewrite recluster searchmap if exists)", default=False, required=True)

        telegram_token_vault_name = sdk2.parameters.String("TelegramBot Token vault name", default="telegram_token",
                                                           required=True)
        chat_id = sdk2.parameters.Integer("Chat ID", default=-1001222981673, required=True)
        recipients = sdk2.parameters.List('Notification recipients', required=True)

    class Requirements(sdk2.Task.Requirements):
        environments = (environments.PipEnvironment('requests'),)

    def _telegram_notification(self, text):
        self.server.notification(
            body=text,
            recipients=self.Parameters.recipients,
            transport=ctn.Transport.TELEGRAM,
        )

    def on_execute(self):
        self.telegram_token = sdk2.task.Vault.data(self.author, self.Parameters.telegram_token_vault_name)

        # bot = common.telegram.TelegramBot(self.telegram_token)
        #
        self._telegram_notification("BACKUP request STARTED: {what} "
                                    "Description: {desc} "
                                    "Owner: {owner} "
                                    "Config: {config} ".format(what=str(self.__class__.__name__),
                                                               desc=self.Parameters.description,
                                                               owner=self.Parameters.owner,
                                                               config=self.Parameters.config))

        logging.info("Config requested, %s!", self.Parameters.config)

        try:
            url = "{url}?config={config}".format(url=self.Parameters.backpackurl,
                                                 config=self.Parameters.config)
            logging.info("Try to make request for url {0}".format(url))
            result = requests.get(url, headers={}, timeout=5, verify=False)
            logging.info("Answer status code: {0}".format(result.status_code))

        except Exception as e:
            logging.info("Exception reached. Exception: {0} Detail:{1} Config: {2}".format(e,
                                                                                           e.message,
                                                                                           self.Parameters.config))
            self._telegram_notification(
                "BACKUP Sandbox task ERROR: {what} Exception: {error} Config: {config}".format(
                    what=str(self.__class__.__name__),
                    error=e,
                    config=self.Parameters.config)
            )
            raise common.errors.TaskFailure("Exception reached. Exception: {0} Detail:{1} Config: {2}"
                                            .format(e,
                                                    e.message,
                                                    self.Parameters.config))

        if result.status_code == 200 or result.status_code == 202:
            logging.info("Add slot was succesed, Answer body: {0}".format(result.text))
        else:
            logging.info("Answer body: {0}".format(result.text))
            logging.info("error: {0} error text:{1}".format(result.status_code, result.text))
            self._telegram_notification(
                "BACKUP Adding slot ERROR: {what} Code: {code} Url: {url} "
                "Another backup in progress?".format(
                    what=str(self.__class__.__name__),
                    code=result.status_code,
                    url=url)
            )
            raise common.errors.TaskFailure("Cannot add slot url:{0}".format(url))

        logging.info(
            "BACKUP Sandbox task finished with SUCCESS: {what} Config: {config}".format(
                what=str(self.__class__.__name__),
                config=self.Parameters.config))

        self._telegram_notification(
            "BACKUP Sandbox task finished with SUCCESS: {what} Config: {config}".format(
                what=str(self.__class__.__name__),
                config=self.Parameters.config)
        )
