import util

import json
import os
import shutil

from sandbox.sdk2 import ResourceData, Task
from sandbox.sdk2.vcs.svn import Arcadia
from sandbox.projects.common.build import parameters as build_params


class CommonParameters(Task.Parameters):
    arcadia_url = build_params.ArcadiaUrl()


def build_configs(task,
                  ctype,
                  loop_conf_name,
                  conf_file_names,
                  conf_bundle_name,
                  loopconf_resource_class,
                  config_resource_class,
                  conf_local_file_names=None,
                  conf_local_resource_classes=None,
                  conf_dir_path="mssngr/router/conf"):

    base_url, revision = task.Parameters.arcadia_url.split("@")
    conf_url = os.path.join(base_url, conf_dir_path, ctype)
    if revision:
        conf_url += "@" + revision
        conf_bundle_name += "_" + ctype + "_" + revision

    conf_dir_path = str(task.path("conf_dir_%s_%s" % (ctype, conf_bundle_name)))
    os.mkdir(conf_dir_path)
    Arcadia.export(conf_url, conf_dir_path)

    if config_resource_class is not None:
        bundle_path = str(task.path(conf_bundle_name))

        for c in conf_file_names:
            destdir = os.path.join(bundle_path, os.path.dirname(c))
            if not os.path.exists(destdir):
                os.makedirs(destdir)
            shutil.copyfile(os.path.join(conf_dir_path, c), os.path.join(bundle_path, c))

        util.create_package(task, bundle_path, config_resource_class)

    if loop_conf_name is not None:
        loop_conf = loopconf_resource_class(task, "loop script", ctype + conf_bundle_name + "_loop.conf")
        loop_conf_data = ResourceData(loop_conf)

        pva_config_path = os.path.join(conf_dir_path, "pva.json")
        if os.path.exists(pva_config_path):
            pva_config = json.load(open(pva_config_path))
            subconfig = pva_config[loop_conf_name]

            with open(str(loop_conf_data.path), "w") as f:
                for c in subconfig:
                    f.write(open(os.path.join(conf_dir_path, c)).read())
                    f.write("\n")
        else:
            shutil.copyfile(os.path.join(conf_dir_path, loop_conf_name), str(loop_conf_data.path))

    if conf_local_file_names is not None and conf_local_resource_classes is not None:
        for idx, conf_local_file_path in enumerate(conf_local_file_names):
            conf_local_resource_class = conf_local_resource_classes[idx]

            conf_local_file_name = os.path.basename(conf_local_file_path)
            conf_local = conf_local_resource_class(
                task, ctype + "_" + conf_local_file_name, ctype  + conf_bundle_name + "_" + conf_local_file_name
            )
            conf_local_data = ResourceData(conf_local)
            with open(str(conf_local_data.path), "w") as fp:
                fp.write(
                    open(
                        os.path.join(
                            conf_dir_path,
                            conf_local_file_path
                        )
                    ).read()
                )
