# -*- coding: utf-8 -*-

import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.build.YaMake as yamake_task
import sandbox.projects.mssngr.geochats.resources as mssngr_resources


class BuildMssngrGeochatsBinaries(yamake_task.YaMakeTask):
    type = 'BUILD_MSSNGR_GEOCHATS_BINARIES'

    TARGET_RESOURCES = [
        mssngr_resources.MSSNGR_GEOCHATS_ORGVISITS_EXECUTABLE,
    ]

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.CheckoutParameter,
        build_params.ClearBuild,
        build_params.TestParameter,
        build_params.UseArcadiaApiFuse,
    ]

    def get_resources(self):
        resources = {}

        for resource in self.TARGET_RESOURCES:
            resources[resource.name] = {
                'description': resource.description,
                'resource_type': resource,
                'resource_path': resource.arcadia_build_name,
            }

        return resources

    def get_targets(self):
        return [resource.arcadia_build_path for resource in self.TARGET_RESOURCES]

    def get_arts(self):
        return [{'path': resource.arcadia_build_path, 'dest': resource.arcadia_build_name} for resource in self.TARGET_RESOURCES]


__Task__ = BuildMssngrGeochatsBinaries
