# -*- coding: utf-8 -*-

import os
import sandbox.projects.mssngr.geochats.resources as mssngr_resources
import sandbox.projects.common.build.parameters as build_params

import sandbox.common.types.client as ctc

from sandbox.projects.common.app_host.options import get_last_stable_resource
from sandbox.projects.common.build.ArcadiaTask import ArcadiaTask
from sandbox.sandboxsdk.process import run_process
from parameters import Env, MinRatingAmount, MinVisits, Period, Actions


class RunMssngrGeochatsOrgvisits(ArcadiaTask):
    type = "RUN_MSSNGR_GEOCHATS_ORGVISITS"

    client_tags = ctc.Tag.Group.LINUX
    execution_space = 4000

    input_parameters = [
        build_params.ArcadiaUrl,
        MinRatingAmount,
        MinVisits,
        Period,
        Env,
        Actions,
    ]

    def do_execute(self):
        os.environ["YT_TOKEN"] = self.get_vault_data(self.owner, "yt-token")

        last_stable_release = get_last_stable_resource(mssngr_resources.MSSNGR_GEOCHATS_ORGVISITS_EXECUTABLE)
        binary_path = self.sync_resource(last_stable_release)
        binary = os.path.join(binary_path, "orgvisits", "orgvisits")

        cmd = [
            binary,
            "--min-rating-amount", self.ctx.get(MinRatingAmount.name),
            "--min-visits", self.ctx.get(MinVisits.name),
            "--period", self.ctx.get(Period.name),
            "--env", self.ctx.get(Env.name),
        ]

        for action in self.ctx.get(Actions.name):
            if action == "update_common":
                cmd.append("--update-common")
            elif action == "update_count":
                cmd.append("--update-count")
            elif action == "update_user_visits":
                cmd.append("--update-user-visits")
            elif action == "export_to_kikimr":
                cmd.append("--export-to-kikimr")

        run_process(cmd, shell=True, log_prefix="run")


__Task__ = RunMssngrGeochatsOrgvisits
