# -*- coding: utf-8 -*-

from sandbox.sdk2.parameters import CheckGroup, Integer, RadioGroup


class MinVisits(Integer):
    name = 'min_visits'
    description = 'Minimum number of visits'
    required = False
    default_value = 10


class MinRatingAmount(Integer):
    name = 'min_rating_amount'
    description = 'Minimum number of votes'
    required = False
    default_value = 5


class Period(Integer):
    name = 'period'
    description = 'Period (days)'
    required = False
    default_value = 7


class Env(RadioGroup):
    name = 'env'
    description = 'Environment'
    choices = [
        ('Testing', 'test'),
        ('Alpha', 'alpha'),
        ('Prod', 'prod'),
    ]
    required = True
    default_value = 'prod'


class Actions(CheckGroup):
    name = 'actions'
    description = 'Actions'
    choices = [
        ('Update common', 'update_common'),
        ('Update count', 'update_count'),
        ('Update user visits', 'update_user_visits'),
        ('Export to kikimr', 'export_to_kikimr'),
    ]
    default_value = 'update_common update_count update_user_visits'
