from sandbox.projects.mssngr.common import build
from sandbox.projects.mssngr.rtc.resource_types import CoturnBundle

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildRtcCoturn(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a coturn bundle"""

    class Requirements(build.CommonRequirements):
        pass

    class Parameters(build.CommonParameters):
        pass

    def on_execute(self):
        build.build_package(
            task=self,
            pkg_name="rtc_coturn",
            resource_class=CoturnBundle,
            base_path="contrib/libs/coturn/src/apps",
            subpaths=["relay/turnserver", "stunclient/stunclient"]
        )
