import os
import shutil

from sandbox.projects.mssngr.common import config, util
from sandbox.projects.mssngr.rtc import resource_types

from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia

from sandbox.projects.common.nanny import nanny


def build_conf_bundle(task, resource, path, bundle_name):
    base_url, revision = task.Parameters.arcadia_url.split("@")
    assert revision
    conf_url = os.path.join(base_url, path) + "@" + revision
    conf_dir_path = str(task.path(path))

    if not os.path.exists(conf_dir_path):
        os.makedirs(conf_dir_path)
    Arcadia.export(conf_url, conf_dir_path)

    bundle_full_name = bundle_name + "_" + revision
    bundle_path = str(task.path(bundle_full_name))

    shutil.copytree(os.path.join(conf_dir_path, "generated"), bundle_path)
    util.create_package(task, bundle_path, resource)


def build_conf_file(task, resource, service, path, fn):
    base_url, revision = task.Parameters.arcadia_url.split("@")
    assert revision
    conf_url = os.path.join(base_url, path) + "@" + revision
    conf_dir_path = str(task.path(path))

    if not os.path.exists(conf_dir_path):
        os.makedirs(conf_dir_path)
    Arcadia.export(conf_url, conf_dir_path)

    resource(task, "{} {}".format(service, fn), os.path.join(conf_dir_path, fn))


class BuildRtcCoturnConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a coturn configs"""

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        stun_service = "stun"
        stun_path = os.path.join("rtc", stun_service, "config")
        build_conf_file(self, resource_types.CoturnStunLoopConf, stun_service, stun_path, "loop.conf")
        build_conf_file(self, resource_types.CoturnStunConfigBundle, stun_service, stun_path, "turnserver.conf")

        turn_service = "turn"
        turn_path = os.path.join("rtc", turn_service, "config")
        build_conf_file(self, resource_types.CoturnTurnLoopConf, turn_service, turn_path, "loop.conf")
        build_conf_bundle(self, resource_types.CoturnTurnConfigBundle, os.path.join(turn_path, "production"), "turn_configs")
        build_conf_bundle(self, resource_types.CoturnTurnTestingConfigBundle, os.path.join(turn_path, "testing"), "turn_configs_testing")
