from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.rtc import resource_types
from sandbox.projects.mssngr.rtc.build_config import build_config, build_loop_conf

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildRtcJanusapiConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a janusapi configs"""

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        files = ["janusapi.conf", "tvm.conf", "push-client.yml"]

        build_loop_conf(self, "sipgw-relay", False, resource_types.JanusapiLoopConf)

        build_config(self, "sipgw-relay", "alpha", resource_types.JanusapiAlphaConfigBundle, files)

        build_config(self, "sipgw-relay", "production", resource_types.JanusapiConfigBundle, files)
