from sandbox.projects.mssngr.common import build
from sandbox.projects.mssngr.rtc.resource_types import MediatorBundle

from sandbox import sdk2

from sandbox.projects.common.ya_deploy import release_integration


class BuildRtcMediator(release_integration.ReleaseToNannyAndYaDeployTask2, sdk2.Task):
    """Builds a mediator bundle"""

    class Requirements(build.CommonRequirements):
        pass

    class Parameters(build.CommonParameters):
        pass

    def on_execute(self):
        build.build_package(
            task=self,
            pkg_name="rtc_mediator",
            resource_class=MediatorBundle,
            base_path="rtc",
            subpaths=["mediator/cmd/mediator/mediator", "mediator/testutil/fanoutmock/cmd/fanoutmock"]
        )
