from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.rtc import resource_types
from sandbox.projects.mssngr.rtc.build_config import build_config, build_loop_conf

from sandbox import sdk2

from sandbox.projects.common.ya_deploy import release_integration


class BuildRtcMediatorBalancerConfig(release_integration.ReleaseToNannyAndYaDeployTask2, sdk2.Task):
    """Builds a balancer configs"""

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        files = ["balancer.conf", "push-client.yml"]

        build_loop_conf(self, "mediator-balancer", False, resource_types.MediatorBalancerLoopConf)

        build_config(self, "mediator-balancer", "testing", resource_types.MediatorBalancerTestingConfingBundle, files)

        build_config(self, "mediator-balancer", "alpha", resource_types.MediatorBalancerAlphaConfingBundle, files)

        build_config(self, "mediator-balancer", "production", resource_types.MediatorBalancerConfingBundle, files)

        loadtest_files = ["balancer.conf"]

        build_config(self, "mediator-balancer", "loadtest", resource_types.MediatorBalancerLoadtestConfingBundle, loadtest_files)
