from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.rtc import resource_types
from sandbox.projects.mssngr.rtc.build_config import build_config, build_loop_conf

from sandbox import sdk2

from sandbox.projects.common.ya_deploy import release_integration


class BuildRtcMediatorConfig(release_integration.ReleaseToNannyAndYaDeployTask2, sdk2.Task):
    """Builds a mediator configs"""

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        loadtest_files = ["mediator.conf", "tvm.conf"]

        build_loop_conf(self, "mediator", True, resource_types.MediatorLoadtestLoopConf)

        build_config(self,
                     "mediator",
                     "loadtest",
                     resource_types.MediatorLoadtestConfingBundle,
                     loadtest_files)

        files = loadtest_files + ["push-client.yml"]

        build_loop_conf(self, "mediator", False, resource_types.MediatorLoopConf)

        build_config(self,
                     "mediator",
                     "testing",
                     resource_types.MediatorTestingConfingBundle,
                     files)

        build_config(self,
                     "mediator",
                     "alpha",
                     resource_types.MediatorAlphaConfingBundle,
                     files)

        build_config(self,
                     "mediator",
                     "production",
                     resource_types.MediatorConfingBundle,
                     files)
