from sandbox import sdk2
from sandbox.projects.common.nanny import nanny

from sandbox.projects.mssngr.common import build
from sandbox.projects.mssngr.rtc.resource_types import RecorderBundle


class BuildRtcRecorder(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a recorder bundle"""

    class Requirements(build.CommonRequirements):
        pass

    class Parameters(build.CommonParameters):
        pass

    def on_execute(self):
        build.build_package(
            task=self,
            pkg_name="rtc_recorder",
            resource_class=RecorderBundle,
            base_path="rtc",
            subpaths=[
                "recorder/recorder",
                "recorder/records/mover/records_mover",
                "recorder/records/restorer/records_restorer"
            ]
        )
