from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.rtc import resource_types
from sandbox.projects.mssngr.rtc.build_config import build_config, build_loop_conf

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildRtcRecorderConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a recorder configs"""

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        files = ["recorder_config.ini", "records_mover_config.ini"]

        build_loop_conf(self, "recorder", False, resource_types.RecorderLoopConf)

        build_config(self,
                     "recorder",
                     "testing",
                     resource_types.RecorderTestingConfigBundle,
                     files)

        build_config(self,
                     "recorder",
                     "alpha",
                     resource_types.RecorderAlphaConfigBundle,
                     files)

        build_config(self,
                     "recorder",
                     "production",
                     resource_types.RecorderConfigBundle,
                     files)
