from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.rtc import resource_types
from sandbox.projects.mssngr.rtc.build_config import build_config, build_loop_conf

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildRtcSipgwBalancerConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a sipgw balancer configs"""

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        files = ["sipgw-balancer.conf", "push-client.yml"]

        build_loop_conf(self, "sipgw-balancer", False, resource_types.SipgwBalancerLoopConf)

        build_config(self, "sipgw-balancer", "alpha", resource_types.SipgwBalancerAlphaConfigBundle, files)

        build_config(self, "sipgw-balancer", "production", resource_types.SipgwBalancerConfigBundle, files)
