from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.rtc import resource_types
from sandbox.projects.mssngr.rtc.build_config import build_config, build_loop_conf

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildRtcSipgwConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a sipgw configs"""

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        files = ["sipgw.conf", "tvm.conf", "push-client.yml"]

        build_loop_conf(self, "sipgw", False, resource_types.SipgwLoopConf)

        build_config(self, "sipgw", "alpha", resource_types.SipgwAlphaConfigBundle, files)

        build_config(self, "sipgw", "production", resource_types.SipgwConfigBundle, files)
