import os
import shutil

from sandbox.projects.mssngr.common import util

from sandbox.sdk2.vcs.svn import Arcadia


def build_config(task, service, ctype, config_resource_class, files):
    base_url, revision = task.Parameters.arcadia_url.split("@")
    assert revision
    conf_url = os.path.join(base_url, "rtc", "configs", service, ctype) + "@" + revision
    conf_dir_path = str(task.path("conf_dir_%s" % ctype))

    if not os.path.exists(conf_dir_path):
        os.makedirs(conf_dir_path)
    Arcadia.export(conf_url, conf_dir_path)

    conf_bundle_name = "%s_configs_" % service + ctype + "_" + revision
    bundle_path = str(task.path(conf_bundle_name))
    if not os.path.exists(bundle_path):
        os.makedirs(bundle_path)
    for fn in files:
        shutil.copyfile(os.path.join(conf_dir_path, fn), os.path.join(bundle_path, fn))
    util.create_package(task, bundle_path, config_resource_class)


def build_loop_conf(task, service, is_loadtest, loopconf_resource_class):
    base_url, revision = task.Parameters.arcadia_url.split("@")
    assert revision
    conf_url = os.path.join(base_url, "rtc", "configs", service) + "@" + revision
    conf_dir_path = str(task.path("conf_dir"))

    if not os.path.exists(conf_dir_path):
        os.makedirs(conf_dir_path)
    Arcadia.export(conf_url, conf_dir_path)

    if is_loadtest:
        additional_path = "loadtest"
        name = "%s loadtest loop.conf" % service
    else:
        additional_path = ""
        name = "%s loop.conf" % service

    loopconf_resource_class(
        task, name, os.path.join(conf_dir_path, additional_path, "loop.conf")
    )
