from sandbox import sdk2


class RtcResource(sdk2.Resource):
    releasers = [
        "ivaxer",
        "yak-dmitriy",
        "thorfinn",
        "robot-srch-releaser",
        "robot-testenv",
        "yamilov",
        "chmerev",
        "manokk",
        "dsamuylov",
        "deligor"
    ]


class RtcExecutableResource(RtcResource):
    executable = True
    releasable = True
    any_arch = False


class RtcConfigResource(RtcResource):
    executable = False
    releasable = True
    any_arch = True


class CoturnBundle(RtcExecutableResource):
    """ Bundle with coturn binaries """


class CoturnStunConfigBundle(RtcConfigResource):
    """ Bundle with coturn configs for STUN """


class CoturnStunLoopConf(RtcConfigResource):
    """ loop.conf for coturn STUN """


class CoturnTurnConfigBundle(RtcConfigResource):
    """ Bundle with coturn configs for TURN """


class CoturnTurnTestingConfigBundle(RtcConfigResource):
    """ Bundle with coturn configs for testing TURN """


class CoturnTurnLoopConf(RtcConfigResource):
    """ loop.conf for coturn TURN """


class MediatorBundle(RtcExecutableResource):
    """ Bundle with mediator binaries """


class MediatorLoopConf(RtcConfigResource):
    """ loop.conf for mediator production service """


class MediatorLoadtestLoopConf(RtcConfigResource):
    """ loop.conf for loadtest mediator service """


class MediatorConfingBundle(RtcConfigResource):
    """ Bundle with mediator configs """


class MediatorAlphaConfingBundle(RtcConfigResource):
    """ Bundle with alpha mediator configs """


class MediatorTestingConfingBundle(RtcConfigResource):
    """ Bundle with testing mediator configs """


class MediatorLoadtestConfingBundle(RtcConfigResource):
    """ Bundle with loadtest mediator configs """


class RecorderBundle(RtcExecutableResource):
    """ Bundle with recorder binaries """


class RecorderLoopConf(RtcConfigResource):
    """ loop.conf for recorder production service """


class RecorderConfigBundle(RtcConfigResource):
    """ Bundle with recorder configs """


class RecorderAlphaConfigBundle(RtcConfigResource):
    """ Bundle with alpha recorder configs """


class RecorderTestingConfigBundle(RtcConfigResource):
    """ Bundle with testing recorder configs """


class SipgwBundle(RtcExecutableResource):
    """ Bundle with sipgw binaries """


class SipgwLoopConf(RtcConfigResource):
    """ loop.conf for sipgw service """


class SipgwConfigBundle(RtcConfigResource):
    """ Bundle with sipgw configs """


class SipgwAlphaConfigBundle(RtcConfigResource):
    """ Bundle with alpha sipgw configs """


class JanusapiLoopConf(RtcConfigResource):
    """ loop.conf for janusapi service """


class JanusapiConfigBundle(RtcConfigResource):
    """ Bundle with janusapi configs """


class JanusapiAlphaConfigBundle(RtcConfigResource):
    """ Bundle with alpha janusapi configs """


class JanusapiBundle(RtcExecutableResource):
    """ Bundle with janusapi binaries """


class FeedbackReasons(RtcResource):
    releasable = True


class SipgwBalancerBundle(RtcExecutableResource):
    """ Bundle with sipgw balancer binaries """


class SipgwBalancerLoopConf(RtcConfigResource):
    """ loop.conf for sipgw balancer service """


class SipgwBalancerConfigBundle(RtcConfigResource):
    """ Bundle with sipgw balancer configs """


class SipgwBalancerAlphaConfigBundle(RtcConfigResource):
    """ Bundle with alpha sipgw balancer configs """


class MediatorBalancerBundle(RtcExecutableResource):
    """ Bundle with mediator balancer binaries """


class MediatorBalancerLoopConf(RtcConfigResource):
    """ loop.conf for mediator balancer service """


class MediatorBalancerConfingBundle(RtcConfigResource):
    """ Bundle with mediator balancer configs """


class MediatorBalancerAlphaConfingBundle(RtcConfigResource):
    """ Bundle with alpha mediator balancer configs """


class MediatorBalancerTestingConfingBundle(RtcConfigResource):
    """ Bundle with alpha mediator balancer configs """


class MediatorBalancerLoadtestConfingBundle(RtcConfigResource):
    """ Bundle with loadtest mediator balancer configs """
