from sandbox.projects.mssngr.common import build
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrBotplatform(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-botplatform and corresponding tools"""

    class Requirements(build.CommonRequirements):
        pass

    class Parameters(build.CommonParameters):
        pass

    def on_execute(self):
        build.build_package(
            task=self,
            pkg_name="mssngr_botplatform",
            resource_class=resources.MssngrBotplatform,
            base_path="mssngr/botplatform",
            subpaths=["bin/mssngr-botplatform"]
        )
