from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrBotplatformConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-botplatform configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        conf_dir_path = "mssngr/botplatform/conf"
        config.build_configs(
            self,
            "production",
            "instancectl.conf",
            ["push_client.yml"],
            "botplatform_config",
            resources.MssngrBotplatformLoopConf,
            resources.MssngrBotplatformConfig,
            ["config.env"],
            [resources.MssngrBotplatformConfLocalConfig],
            conf_dir_path
        )
        config.build_configs(
            self,
            "alpha",
            "instancectl.conf",
            [],
            "botplatform_config",
            resources.MssngrBotplatformAlphaLoopConf,
            None,
            ["config.env"],
            [resources.MssngrBotplatformConfLocalAlphaConfig],
            conf_dir_path
        )
        config.build_configs(
            self,
            "testing",
            "instancectl.conf",
            [],
            "botplatform_config",
            resources.MssngrBotplatformTestingLoopConf,
            None,
            ["config.env"],
            [resources.MssngrBotplatformConfLocalTestingConfig],
            conf_dir_path
        )
