import logging
import os
import tarfile

from sandbox.projects.mssngr.common import build, util
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia

from sandbox.projects.common.arcadia.sdk import do_build
from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.nanny import nanny


class BuildMssngrBotplatformData(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-botplatform data"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = build_params.ArcadiaUrl()

    def on_execute(self):
        bundle_name = "mssngr_botplatform_data"
        base_path = "mssngr/botplatform"

        data_dir_path = os.path.join(base_path, "data")
        build_target_path = os.path.join(base_path, "docs")
        archives = {
            "internal/docs.tar.gz": "site-private",
            "external/docs.tar.gz": "site-public"
        }

        build_dir = str(self.path("build_{}".format(bundle_name)))
        os.mkdir(build_dir)

        arcadia_url = self.Parameters.arcadia_url
        logging.info(arcadia_url)

        with build.get_arcadia(arcadia_url) as arcadia_dir:
            do_build(
                build_system="semi_distbuild",
                source_root=arcadia_dir,
                targets=[build_target_path],
                clear_build=True,
                results_dir=build_dir
            )

        parsed_url = Arcadia.parse_url(arcadia_url)
        assert parsed_url.revision

        rev = parsed_url.revision
        versioned_bundle_name = "{}_r{}".format(bundle_name, rev)
        logging.info(versioned_bundle_name)

        package_dir = os.path.join(build_dir, versioned_bundle_name)
        os.mkdir(package_dir)

        Arcadia.export("{}@{}".format(os.path.join(arcadia_url.split('@')[0], data_dir_path), rev), package_dir)

        for arc, dest in archives.iteritems():
            with tarfile.open(os.path.join(build_dir, build_target_path, arc)) as tar:
                tar.extractall(path=os.path.join(package_dir, dest))

        util.create_package(self, package_dir, resources.MssngrBotplatformData)
