from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrChatMirrorConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-chat-mirror configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            "mssngr_chat_mirror_loop.conf",
            [
                "templates/mssngr-chat-mirror.json",
                "templates/nginx_common.conf",
                "templates/entrypoints.json",
                "data/tvm-ids.json",
            ],
            "mssngr_chat_mirror_config",
            resources.MssngrChatMirrorLoopConf,
            resources.MssngrChatMirrorConfig
        )
        config.build_configs(
            self,
            "testing",
            "mssngr_chat_mirror_loop.conf",
            [
                "templates/mssngr-chat-mirror.json",
                "templates/nginx_common.conf",
                "templates/entrypoints.json",
                "data/tvm-ids.json",
            ],
            "mssngr_chat_mirror_config",
            resources.MssngrChatMirrorTestingLoopConf,
            resources.MssngrChatMirrorTestingConfig
        )
