from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrCsServerConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-cs-server configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            "mssngr_cs_server_loop.conf",
            [
                "templates/client-config.json",
                "templates/mssngr-cs-server.json",
                "templates/nginx_cs.conf",
                "data/tvm-ids.json",
            ],
            "mssngr_cs_server_config",
            resources.MssngrCsServerLoopConf,
            resources.MssngrCsServerConfig
        )
