from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrDataCollectorConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with data-collector configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            "mssngr_data_collector_loop.conf",
            [
                "templates/data-collector.json",
                "templates/push_client.yml",
                "templates/nginx_gdpr.conf",
                "data/tvm-ids.json",
            ],
            "mssngr_data_collector_config",
            resources.MssngrDataCollectorLoopConf,
            resources.MssngrDataCollectorConfig
        )
        config.build_configs(
            self,
            "testing",
            "mssngr_data_collector_loop.conf",
            [
                "templates/data-collector.json",
                "templates/nginx_gdpr.conf",
                "data/tvm-ids.json",
            ],
            "mssngr_data_collector_config",
            resources.MssngrDataCollectorTestingLoopConf,
            resources.MssngrDataCollectorTestingConfig
        )
