from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrFilesConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-files configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            "mssngr_files_loop.conf",
            [
                "templates/mssngr-files.json",
                "templates/push_client-files-rtc.yml",
            ],
            "files_config",
            resources.MssngrFilesLoopConf,
            resources.MssngrFilesConfig,
            ["templates/files_Conf.local"],
            [resources.MssngrFilesConfLocalConfig]
        )
        config.build_configs(
            self,
            "testing",
            "mssngr_files_loop.conf",
            [
                "templates/mssngr-files.json",
            ],
            "files_config",
            resources.MssngrFilesTestingLoopConf,
            resources.MssngrFilesTestingConfig,
            ["templates/files_Conf.local"],
            [resources.MssngrFilesConfLocalTestingConfig]
        )
        config.build_configs(
            self,
            "alpha",
            "mssngr_files_loop.conf",
            [
                "templates/mssngr-files.json",
            ],
            "files_config",
            resources.MssngrFilesAlphaLoopConf,
            resources.MssngrFilesAlphaConfig,
            ["templates/files_Conf.local"],
            [resources.MssngrFilesConfLocalAlphaConfig]
        )
