from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrGeoBotConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-geobot configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            "mssngr_geobot_loop.conf",
            [
                "templates/mssngr-geobot.json",
                "templates/push_client.yml",
                "data/tvm-ids.json",
            ],
            "mssngr_geobot_config",
            resources.MssngrGeoBotLoopConf,
            resources.MssngrGeoBotConfig
        )
        config.build_configs(
            self,
            "testing",
            "mssngr_geobot_loop.conf",
            [
                "templates/mssngr-geobot.json",
                "data/tvm-ids.json",
            ],
            "mssngr_geobot_config",
            resources.MssngrGeoBotTestingLoopConf,
            resources.MssngrGeoBotTestingConfig
        )
        config.build_configs(
            self,
            "alpha",
            "mssngr_geobot_loop.conf",
            [
                "templates/mssngr-geobot.json",
                "data/tvm-ids.json",
            ],
            "mssngr_geobot_config",
            resources.MssngrGeoBotAlphaLoopConf,
            resources.MssngrGeoBotAlphaConfig
        )
