import os

from sandbox.projects.mssngr.common import config, util
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny

from sandbox.sdk2.vcs.svn import Arcadia


class BuildMssngrMessageViewerData(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-message-viewer static data"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        base_url, revision = self.Parameters.arcadia_url.split("@")
        data_url = os.path.join(base_url, "mssngr/router/tools/message_viewer")
        if revision:
            data_url += "@" + revision

        data_dir_path = str(self.path("message_viewer_data_dir"))
        os.mkdir(data_dir_path)
        Arcadia.export(data_url, data_dir_path)

        util.create_package(
            self,
            data_dir_path,
            resources.MssngrMessageViewerData
        )
