from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrMetasearchConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-metasearch configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            "mssngr_metasearch_loop.conf",
            [
                "templates/mssngr-metasearch.json",
                "templates/nginx_common.conf",
                "templates/push_client.yml",
                "data/tvm-ids.json",
            ],
            "mssngr_metasearch_config",
            resources.MssngrMetasearchLoopConf,
            resources.MssngrMetasearchConfig
        )
        config.build_configs(
            self,
            "testing",
            "mssngr_metasearch_loop.conf",
            [
                "templates/mssngr-metasearch.json",
                "templates/nginx_common.conf",
                "data/tvm-ids.json",
            ],
            "mssngr_metasearch_config",
            resources.MssngrMetasearchTestingLoopConf,
            resources.MssngrMetasearchTestingConfig
        )
        config.build_configs(
            self,
            "alpha",
            "mssngr_metasearch_loop.conf",
            [
                "templates/mssngr-metasearch.json",
                "templates/nginx_common.conf",
                "data/tvm-ids.json",
            ],
            "mssngr_metasearch_config",
            resources.MssngrMetasearchAlphaLoopConf,
            resources.MssngrMetasearchAlphaConfig
        )
