from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrRegistryConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-registry configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            "mssngr_registry_loop.conf",
            [
                "templates/mssngr-registry.json",
                "templates/mssngr-contacts_indexer.json",
                "templates/moderation.json",
                "templates/common_config.json",
                "templates/push_client-registry-rtc.yml",
            ],
            "registry_config",
            resources.MssngrRegistryLoopConf,
            resources.MssngrRegistryConfig,
            ["templates/registry_Conf.local"],
            [resources.MssngrYambConfLocalConfig]
        )
        config.build_configs(
            self,
            "production",
            "mssngr_registry_internal_loop.conf",
            [
                "templates/mssngr-registry.json",
                "templates/moderation.json",
                "templates/common_config.json",
                "templates/push_client-registry-rtc.yml",
            ],
            "registry_internal_config",
            resources.MssngrRegistryInternalLoopConf,
            resources.MssngrRegistryInternalConfig,
            ["templates/registry_internal_Conf.local"],
            [resources.MssngrYambInternalConfLocalConfig]
        )
        config.build_configs(
            self,
            "testing",
            "mssngr_registry_loop.conf",
            [
                "templates/mssngr-registry.json",
                "templates/mssngr-contacts_indexer.json",
                "templates/moderation.json",
                "templates/common_config.json",
            ],
            "registry_config",
            resources.MssngrRegistryTestingLoopConf,
            resources.MssngrRegistryTestingConfig,
            ["templates/registry_Conf.local"],
            [resources.MssngrYambConfLocalTestingConfig]
        )
        config.build_configs(
            self,
            "alpha",
            "mssngr_registry_internal_loop.conf",
            [
                "templates/mssngr-registry.json",
                "templates/moderation.json",
                "templates/common_config.json",
            ],
            "registry_internal_config",
            resources.MssngrRegistryInternalAlphaLoopConf,
            resources.MssngrRegistryInternalAlphaConfig,
            ["templates/registry_internal_Conf.local"],
            [resources.MssngrYambInternalConfLocalAlphaConfig]
        )
        config.build_configs(
            self,
            "alpha",
            "mssngr_registry_loop.conf",
            [
                "templates/mssngr-registry.json",
                "templates/mssngr-contacts_indexer.json",
                "templates/moderation.json",
                "templates/common_config.json",
            ],
            "registry_config",
            resources.MssngrRegistryAlphaLoopConf,
            resources.MssngrRegistryAlphaConfig,
            ["templates/registry_Conf.local"],
            [resources.MssngrYambConfLocalAlphaConfig]
        )
