from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrRouterBalancerConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-balancer configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            "mssngr_balancer_loop.conf",
            [
                "templates/mssngr-balancer.json",
                "templates/push_client-balancer.yml",
                "templates/nginx.conf",
                "data/tvm-ids.json",
                "nginx_lua/dkjson.lua",
                "nginx_lua/init.lua",
                "nginx_lua/metrics.lua",
                "nginx_lua/worker.lua",
            ],
            "mssngr_balancer_config",
            resources.MssngrRouterBalancerLoopConf,
            resources.MssngrRouterBalancerConfig
        )
        config.build_configs(
            self,
            "testing",
            "mssngr_balancer_loop.conf",
            [
                "templates/mssngr-balancer.json",
                "templates/nginx.conf",
                "data/tvm-ids.json",
                "nginx_lua/dkjson.lua",
                "nginx_lua/init.lua",
                "nginx_lua/metrics.lua",
                "nginx_lua/worker.lua",
            ],
            "mssngr_balancer_config",
            resources.MssngrRouterBalancerTestingLoopConf,
            resources.MssngrRouterBalancerTestingConfig
        )
        config.build_configs(
            self,
            "alpha",
            "mssngr_balancer_loop.conf",
            [
                "templates/mssngr-balancer.json",
                "templates/nginx.conf",
                "data/tvm-ids.json",
                "nginx_lua/dkjson.lua",
                "nginx_lua/init.lua",
                "nginx_lua/metrics.lua",
                "nginx_lua/worker.lua",
            ],
            "mssngr_balancer_config",
            resources.MssngrRouterBalancerAlphaLoopConf,
            resources.MssngrRouterBalancerAlphaConfig
        )
